/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import model.TagCatalog;

public class PresetCounter {
    private List<TagCatalog.IndoorObject> rankingList;
    private List<ObjectCounter> counterList;

    public PresetCounter() {
        this.init();
    }

    private void init() {
        this.counterList = new ArrayList<ObjectCounter>();
        this.counterList.add(new ObjectCounter(TagCatalog.IndoorObject.CONCRETE_WALL, 0));
        this.counterList.add(new ObjectCounter(TagCatalog.IndoorObject.DOOR, 0));
        this.counterList.add(new ObjectCounter(TagCatalog.IndoorObject.ELEVATOR, 0));
        this.counterList.add(new ObjectCounter(TagCatalog.IndoorObject.ENTRANCE, 0));
        this.counterList.add(new ObjectCounter(TagCatalog.IndoorObject.GLASS_WALL, 0));
        this.counterList.add(new ObjectCounter(TagCatalog.IndoorObject.ROOM, 0));
        this.counterList.add(new ObjectCounter(TagCatalog.IndoorObject.SHELL, 0));
        this.counterList.add(new ObjectCounter(TagCatalog.IndoorObject.STAIRWAYS, 0));
        this.counterList.add(new ObjectCounter(TagCatalog.IndoorObject.STEPS, 0));
        this.counterList.add(new ObjectCounter(TagCatalog.IndoorObject.TOILET_FEMALE, 0));
        this.counterList.add(new ObjectCounter(TagCatalog.IndoorObject.TOILET_MALE, 0));
    }

    public void count(TagCatalog.IndoorObject object) {
        ListIterator<ObjectCounter> iterator = this.counterList.listIterator();
        while (iterator.hasNext()) {
            ObjectCounter counterTemp = iterator.next();
            if (!counterTemp.getObject().equals((Object)object)) continue;
            this.counterList.get(iterator.nextIndex() - 1).increment();
        }
        this.sort();
    }

    private void sort() {
        Collections.sort(this.counterList);
        Collections.reverse(this.counterList);
    }

    public List<TagCatalog.IndoorObject> getRanking() {
        this.rankingList = new ArrayList<TagCatalog.IndoorObject>();
        this.rankingList.add(this.counterList.get(0).getObject());
        this.rankingList.add(this.counterList.get(1).getObject());
        this.rankingList.add(this.counterList.get(2).getObject());
        this.rankingList.add(this.counterList.get(3).getObject());
        return this.rankingList;
    }

    private class ObjectCounter
    implements Comparable<ObjectCounter> {
        private TagCatalog.IndoorObject object;
        private int count;

        public ObjectCounter(TagCatalog.IndoorObject o, int c) {
            this.object = o;
            this.count = c;
        }

        public int getCount() {
            return this.count;
        }

        public TagCatalog.IndoorObject getObject() {
            return this.object;
        }

        public void increment() {
            ++this.count;
        }

        @Override
        public int compareTo(ObjectCounter o) {
            if (this.getCount() < o.getCount()) {
                return -1;
            }
            if (this.getCount() == o.getCount()) {
                return 0;
            }
            if (this.getCount() > o.getCount()) {
                return 1;
            }
            return 0;
        }
    }
}

