/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import model.IndoorLevel;
import model.PresetCounter;
import model.TagCatalog;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.dialogs.FilterDialog;
import org.openstreetmap.josm.gui.dialogs.FilterTableModel;

public class IndoorHelperModel {
    private List<IndoorLevel> levelList = new ArrayList<IndoorLevel>();
    private int workingLevel = 0;
    private int workingIndex;
    private TagCatalog tags = new TagCatalog();
    private PresetCounter counter = new PresetCounter();

    public boolean setBuildingLevels(int minLevel, int maxLevel) {
        if (minLevel < maxLevel) {
            for (int i = minLevel; i <= maxLevel; ++i) {
                IndoorLevel level = new IndoorLevel(i);
                this.levelList.add(level);
                FilterDialog filterDialog = (FilterDialog)Main.map.getToggleDialog(FilterDialog.class);
                if (filterDialog != null) {
                    Filter.FilterPreferenceEntry entry = new Filter.FilterPreferenceEntry();
                    entry.case_sensitive = false;
                    entry.enable = false;
                    entry.hiding = false;
                    entry.inverted = false;
                    entry.mapCSS_search = false;
                    entry.mode = "add";
                    entry.text = "\"indoor:level\"=\"" + i + "\"";
                    Filter filter = new Filter(entry);
                    FilterTableModel filterTableModel = filterDialog.getFilterModel();
                    boolean exists = false;
                    for (Filter listFilter : filterTableModel.getFilters()) {
                        if (!listFilter.equals((Object)filter)) continue;
                        exists = true;
                    }
                    if (exists) continue;
                    filterTableModel.addFilter(filter);
                    continue;
                }
                JOptionPane.showMessageDialog(null, "Filter Dialog is null.", "Error", 0);
            }
            return true;
        }
        if (minLevel == maxLevel) {
            IndoorLevel level = new IndoorLevel(minLevel);
            this.levelList.add(level);
            FilterDialog filterDialog = (FilterDialog)Main.map.getToggleDialog(FilterDialog.class);
            if (filterDialog != null) {
                Filter.FilterPreferenceEntry entry = new Filter.FilterPreferenceEntry();
                entry.case_sensitive = false;
                entry.enable = false;
                entry.hiding = false;
                entry.inverted = false;
                entry.mapCSS_search = false;
                entry.mode = "add";
                entry.text = "\"indoor:level\"=\"" + minLevel + "\"";
                Filter filter = new Filter(entry);
                FilterTableModel filterTableModel = filterDialog.getFilterModel();
                boolean exists = false;
                for (Filter listFilter : filterTableModel.getFilters()) {
                    if (!listFilter.equals((Object)filter)) continue;
                    exists = true;
                }
                if (!exists) {
                    filterTableModel.addFilter(filter);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Filter Dialog is null.", "Error", 0);
            }
            return true;
        }
        return false;
    }

    public List<IndoorLevel> getLevelList() {
        return this.levelList;
    }

    public void setWorkingLevel(int index) {
        this.workingIndex = index;
        this.workingLevel = this.getLevelNumberFromIndex(index);
        FilterDialog filterDialog = (FilterDialog)Main.map.getToggleDialog(FilterDialog.class);
        FilterTableModel filterTableModel = filterDialog.getFilterModel();
        for (Filter filter : filterTableModel.getFilters()) {
            if (filter.text.equals("\"indoor:level\"=\"" + this.workingLevel + "\"")) {
                filterTableModel.setValueAt((Object)false, filterTableModel.getFilters().indexOf(filter), 0);
                filterTableModel.setValueAt((Object)false, filterTableModel.getFilters().indexOf(filter), 1);
                continue;
            }
            if (!filter.text.startsWith("\"indoor:level\"=\"")) continue;
            filterTableModel.setValueAt((Object)true, filterTableModel.getFilters().indexOf(filter), 0);
            filterTableModel.setValueAt((Object)true, filterTableModel.getFilters().indexOf(filter), 1);
        }
    }

    public int getWorkingLevel() {
        return this.workingLevel;
    }

    public int getWorkingIndex() {
        return this.workingIndex;
    }

    public int getLevelNumberFromIndex(int index) {
        return this.levelList.get(index).getLevelNumber();
    }

    public void setLevelName(int levelIndex, String levelName) {
        if (levelName.length() > 0 && levelName != null) {
            this.levelList.get(levelIndex).setNameTag(levelName);
        }
    }

    public List<Tag> getObjectTags(TagCatalog.IndoorObject object) {
        return this.tags.getTags(object);
    }

    public void addTagsToOSM(TagCatalog.IndoorObject object, List<Tag> userTags) {
        if (!Main.main.getCurrentDataSet().selectionEmpty() && !Main.main.getInProgressSelection().isEmpty()) {
            List<Tag> tags = this.getObjectTags(object);
            tags.addAll(userTags);
            tags.add(new Tag("indoor:level", Integer.toString(this.workingLevel)));
            if (!this.getLevelList().get(this.workingIndex).hasEmptyName()) {
                tags.add(this.getLevelList().get(this.workingIndex).getNameTag());
            }
            this.counter.count(object);
            for (Tag t : tags) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand(Main.main.getInProgressSelection(), t.getKey(), t.getValue()));
            }
        } else if (Main.main.getCurrentDataSet().selectionEmpty()) {
            JOptionPane.showMessageDialog(null, "No data selected.", "Error", 0);
        }
    }

    public void addTagsToOSM(TagCatalog.IndoorObject object) {
        if (!Main.main.getCurrentDataSet().selectionEmpty() && !Main.main.getInProgressSelection().isEmpty()) {
            List<Tag> tags = this.getObjectTags(object);
            tags.add(new Tag("indoor:level", Integer.toString(this.workingLevel)));
            this.counter.count(object);
            for (Tag t : tags) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand(Main.main.getInProgressSelection(), t.getKey(), t.getValue()));
            }
        } else if (Main.main.getCurrentDataSet().selectionEmpty()) {
            JOptionPane.showMessageDialog(null, "No data selected.", "Error", 0);
        }
    }

    public List<TagCatalog.IndoorObject> getPresetRanking() {
        return this.counter.getRanking();
    }
}

