/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.common.POIFSBigBlockSize;
import org.apache.poi.poifs.common.POIFSConstants;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;

public final class HeaderBlockReader {
    private final POIFSBigBlockSize bigBlockSize;
    private final int _bat_count;
    private final int _property_start;
    private final int _sbat_start;
    private final int _xbat_start;
    private final int _xbat_count;
    private final byte[] _data;

    public HeaderBlockReader(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[32];
        int n = IOUtils.readFully(inputStream, byArray);
        if (n != 32) {
            throw HeaderBlockReader.alertShortRead(n, 32);
        }
        long l = LittleEndian.getLong(byArray, 0);
        if (l != -2226271756974174256L) {
            byte[] byArray2 = POIFSConstants.OOXML_FILE_HEADER;
            if (byArray[0] == byArray2[0] && byArray[1] == byArray2[1] && byArray[2] == byArray2[2] && byArray[3] == byArray2[3]) {
                throw new OfficeXmlFileException("The supplied data appears to be in the Office 2007+ XML. You are calling the part of POI that deals with OLE2 Office Documents. You need to call a different part of POI to process this data (eg XSSF instead of HSSF)");
            }
            if ((l & 0xFF8FFFFFFFFFFFFFL) == 4503608217567241L) {
                throw new IllegalArgumentException("The supplied data appears to be in BIFF2 format.  POI only supports BIFF8 format");
            }
            throw new IOException("Invalid header signature; read " + HeaderBlockReader.longToHex(l) + ", expected " + HeaderBlockReader.longToHex(-2226271756974174256L));
        }
        switch (byArray[30]) {
            case 12: {
                this.bigBlockSize = POIFSConstants.LARGER_BIG_BLOCK_SIZE_DETAILS;
                break;
            }
            case 9: {
                this.bigBlockSize = POIFSConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS;
                break;
            }
            default: {
                throw new IOException("Unsupported blocksize  (2^" + byArray[30] + "). Expected 2^9 or 2^12.");
            }
        }
        this._data = new byte[this.bigBlockSize.getBigBlockSize()];
        System.arraycopy(byArray, 0, this._data, 0, byArray.length);
        int n2 = IOUtils.readFully(inputStream, this._data, byArray.length, this._data.length - byArray.length);
        if (n2 + n != this.bigBlockSize.getBigBlockSize()) {
            throw HeaderBlockReader.alertShortRead(n2, this.bigBlockSize.getBigBlockSize());
        }
        this._bat_count = HeaderBlockReader.getInt(44, this._data);
        this._property_start = HeaderBlockReader.getInt(48, this._data);
        this._sbat_start = HeaderBlockReader.getInt(60, this._data);
        this._xbat_start = HeaderBlockReader.getInt(68, this._data);
        this._xbat_count = HeaderBlockReader.getInt(72, this._data);
    }

    private static int getInt(int n, byte[] byArray) {
        return LittleEndian.getInt(byArray, n);
    }

    private static String longToHex(long l) {
        return new String(HexDump.longToHex(l));
    }

    private static IOException alertShortRead(int n, int n2) {
        int n3 = n < 0 ? 0 : n;
        String string = " byte" + (n3 == 1 ? "" : "s");
        return new IOException("Unable to read entire header; " + n3 + string + " read; expected " + n2 + " bytes");
    }

    public int getPropertyStart() {
        return this._property_start;
    }

    public int getSBATStart() {
        return this._sbat_start;
    }

    public int getBATCount() {
        return this._bat_count;
    }

    public int[] getBATArray() {
        int[] nArray = new int[109];
        int n = 76;
        for (int i = 0; i < 109; ++i) {
            nArray[i] = LittleEndian.getInt(this._data, n);
            n += 4;
        }
        return nArray;
    }

    public int getXBATCount() {
        return this._xbat_count;
    }

    public int getXBATIndex() {
        return this._xbat_start;
    }

    public POIFSBigBlockSize getBigBlockSize() {
        return this.bigBlockSize;
    }
}

