/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.formula.RefPtgBase;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

abstract class Ref2DPtgBase
extends RefPtgBase {
    private static final int SIZE = 5;

    protected Ref2DPtgBase(int n, int n2, boolean bl, boolean bl2) {
        this.setRow(n);
        this.setColumn(n2);
        this.setRowRelative(bl);
        this.setColRelative(bl2);
    }

    protected Ref2DPtgBase(LittleEndianInput littleEndianInput) {
        this.readCoordinates(littleEndianInput);
    }

    @Override
    public void write(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeByte(this.getSid() + this.getPtgClass());
        this.writeCoordinates(littleEndianOutput);
    }

    @Override
    public final String toFormulaString() {
        return this.formatReferenceAsString();
    }

    protected abstract byte getSid();

    @Override
    public final int getSize() {
        return 5;
    }

    @Override
    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" [");
        stringBuffer.append(this.formatReferenceAsString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

