/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import org.apache.poi.util.FixedField;
import org.apache.poi.util.LittleEndian;

public class ShortField
implements FixedField {
    private short _value;
    private final int _offset;

    public ShortField(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Illegal offset: " + n);
        }
        this._offset = n;
    }

    public ShortField(int n, byte[] byArray) throws ArrayIndexOutOfBoundsException {
        this(n);
        this.readFromBytes(byArray);
    }

    public ShortField(int n, short s, byte[] byArray) throws ArrayIndexOutOfBoundsException {
        this(n);
        this.set(s, byArray);
    }

    public short get() {
        return this._value;
    }

    public void set(short s, byte[] byArray) throws ArrayIndexOutOfBoundsException {
        this._value = s;
        this.writeToBytes(byArray);
    }

    @Override
    public void readFromBytes(byte[] byArray) throws ArrayIndexOutOfBoundsException {
        this._value = LittleEndian.getShort(byArray, this._offset);
    }

    @Override
    public void writeToBytes(byte[] byArray) throws ArrayIndexOutOfBoundsException {
        LittleEndian.putShort(byArray, this._offset, this._value);
    }

    @Override
    public String toString() {
        return String.valueOf(this._value);
    }
}

