/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public final class DBCellRecord
extends StandardRecord {
    public static final short sid = 215;
    public static final int BLOCK_SIZE = 32;
    private final int field_1_row_offset;
    private final short[] field_2_cell_offsets;

    DBCellRecord(int n, short[] sArray) {
        this.field_1_row_offset = n;
        this.field_2_cell_offsets = sArray;
    }

    public DBCellRecord(RecordInputStream recordInputStream) {
        this.field_1_row_offset = recordInputStream.readUShort();
        int n = recordInputStream.remaining();
        this.field_2_cell_offsets = new short[n / 2];
        for (int i = 0; i < this.field_2_cell_offsets.length; ++i) {
            this.field_2_cell_offsets[i] = recordInputStream.readShort();
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[DBCELL]\n");
        stringBuffer.append("    .rowoffset = ").append(HexDump.intToHex(this.field_1_row_offset)).append("\n");
        for (int i = 0; i < this.field_2_cell_offsets.length; ++i) {
            stringBuffer.append("    .cell_").append(i).append(" = ").append(HexDump.shortToHex(this.field_2_cell_offsets[i])).append("\n");
        }
        stringBuffer.append("[/DBCELL]\n");
        return stringBuffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeInt(this.field_1_row_offset);
        for (int i = 0; i < this.field_2_cell_offsets.length; ++i) {
            littleEndianOutput.writeShort(this.field_2_cell_offsets[i]);
        }
    }

    @Override
    protected int getDataSize() {
        return 4 + this.field_2_cell_offsets.length * 2;
    }

    @Override
    public short getSid() {
        return 215;
    }

    @Override
    public Object clone() {
        return this;
    }

    public static final class Builder {
        private short[] _cellOffsets = new short[4];
        private int _nCellOffsets;

        public void addCellOffset(int n) {
            if (this._cellOffsets.length <= this._nCellOffsets) {
                short[] sArray = new short[this._nCellOffsets * 2];
                System.arraycopy(this._cellOffsets, 0, sArray, 0, this._nCellOffsets);
                this._cellOffsets = sArray;
            }
            this._cellOffsets[this._nCellOffsets] = (short)n;
            ++this._nCellOffsets;
        }

        public DBCellRecord build(int n) {
            short[] sArray = new short[this._nCellOffsets];
            System.arraycopy(this._cellOffsets, 0, sArray, 0, this._nCellOffsets);
            return new DBCellRecord(n, sArray);
        }
    }
}

