/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.TreeMap;

public class LineWrappingHandler {
    private final IndentationCheck indentCheck;

    public LineWrappingHandler(IndentationCheck instance) {
        this.indentCheck = instance;
    }

    public void checkIndentation(DetailAST firstNode, DetailAST lastNode) {
        this.checkIndentation(firstNode, lastNode, this.indentCheck.getLineWrappingIndentation());
    }

    public void checkIndentation(DetailAST firstNode, DetailAST lastNode, int indentLevel) {
        NavigableMap<Integer, DetailAST> firstNodesOnLines = this.collectFirstNodes(firstNode, lastNode);
        DetailAST firstLineNode = (DetailAST)firstNodesOnLines.get(firstNodesOnLines.firstKey());
        if (firstLineNode.getType() == 170) {
            this.checkAnnotationIndentation(firstLineNode, firstNodesOnLines, indentLevel);
        }
        firstNodesOnLines.remove(firstNodesOnLines.firstKey());
        int firstNodeIndent = this.getFirstNodeIndent(firstLineNode);
        int currentIndent = firstNodeIndent + indentLevel;
        for (DetailAST node : firstNodesOnLines.values()) {
            int currentType = node.getType();
            if (currentType == 73 || currentType == 77 || currentType == 29) {
                this.logWarningMessage(node, firstNodeIndent);
                continue;
            }
            this.logWarningMessage(node, currentIndent);
        }
    }

    private int getFirstNodeIndent(DetailAST node) {
        int result;
        if (node.getType() == 83 && node.getParent().getType() == 92) {
            DetailAST lcurly = node.getParent().getPreviousSibling();
            DetailAST rcurly = lcurly.getLastChild();
            result = lcurly.getType() == 7 && rcurly.getLineNo() == node.getLineNo() ? this.expandedTabsColumnNo(rcurly) : this.expandedTabsColumnNo(node.getParent());
        } else {
            result = this.expandedTabsColumnNo(node);
        }
        return result;
    }

    private NavigableMap<Integer, DetailAST> collectFirstNodes(DetailAST firstNode, DetailAST lastNode) {
        TreeMap<Integer, DetailAST> result = new TreeMap<Integer, DetailAST>();
        result.put(firstNode.getLineNo(), firstNode);
        DetailAST curNode = firstNode.getFirstChild();
        while (curNode != lastNode) {
            DetailAST firstTokenOnLine;
            if (curNode.getType() == 6 || curNode.getType() == 7) {
                curNode = curNode.getLastChild();
            }
            if ((firstTokenOnLine = (DetailAST)result.get(curNode.getLineNo())) == null || this.expandedTabsColumnNo(firstTokenOnLine) >= this.expandedTabsColumnNo(curNode)) {
                result.put(curNode.getLineNo(), curNode);
            }
            curNode = LineWrappingHandler.getNextCurNode(curNode);
        }
        return result;
    }

    private static DetailAST getNextCurNode(DetailAST curNode) {
        DetailAST nodeToVisit = curNode.getFirstChild();
        DetailAST currentNode = curNode;
        while (nodeToVisit == null) {
            nodeToVisit = currentNode.getNextSibling();
            if (nodeToVisit != null) continue;
            currentNode = currentNode.getParent();
        }
        return nodeToVisit;
    }

    private void checkAnnotationIndentation(DetailAST atNode, NavigableMap<Integer, DetailAST> firstNodesOnLines, int indentLevel) {
        DetailAST node;
        int firstNodeIndent = this.expandedTabsColumnNo(atNode);
        int currentIndent = firstNodeIndent + indentLevel;
        Collection values = firstNodesOnLines.values();
        DetailAST lastAnnotationNode = LineWrappingHandler.getLastAnnotationNode(atNode);
        int lastAnnotationLine = lastAnnotationNode.getLineNo();
        Iterator itr = values.iterator();
        while (firstNodesOnLines.size() > 1 && (node = (DetailAST)itr.next()).getLineNo() <= lastAnnotationLine) {
            boolean isCurrentNodeCloseAnnotationAloneInLine;
            DetailAST parentNode = node.getParent();
            boolean bl = isCurrentNodeCloseAnnotationAloneInLine = node.getLineNo() == lastAnnotationLine && node.equals(lastAnnotationNode);
            if (isCurrentNodeCloseAnnotationAloneInLine || node.getType() == 170 && parentNode.getParent().getType() == 5) {
                this.logWarningMessage(node, firstNodeIndent);
            } else {
                this.logWarningMessage(node, currentIndent);
            }
            itr.remove();
        }
    }

    private int expandedTabsColumnNo(DetailAST ast) {
        String line = this.indentCheck.getLine(ast.getLineNo() - 1);
        return CommonUtils.lengthExpandedTabs(line, ast.getColumnNo(), this.indentCheck.getIndentationTabWidth());
    }

    private static DetailAST getLastAnnotationNode(DetailAST atNode) {
        DetailAST lastAnnotation = atNode.getParent();
        while (lastAnnotation.getNextSibling() != null && lastAnnotation.getNextSibling().getType() == 159) {
            lastAnnotation = lastAnnotation.getNextSibling();
        }
        return lastAnnotation.getLastChild();
    }

    private void logWarningMessage(DetailAST currentNode, int currentIndent) {
        if (this.indentCheck.isForceStrictCondition()) {
            if (this.expandedTabsColumnNo(currentNode) != currentIndent) {
                this.indentCheck.indentationLog(currentNode.getLineNo(), "indentation.error", currentNode.getText(), this.expandedTabsColumnNo(currentNode), currentIndent);
            }
        } else if (this.expandedTabsColumnNo(currentNode) < currentIndent) {
            this.indentCheck.indentationLog(currentNode.getLineNo(), "indentation.error", currentNode.getText(), this.expandedTabsColumnNo(currentNode), currentIndent);
        }
    }
}

