/*
 * Decompiled with CFR 0.152.
 */
package indoor_sweepline;

import indoor_sweepline.CorridorPart;
import indoor_sweepline.ModelGeography;
import java.util.Vector;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;

public class CorridorGeography {
    private DataSet dataSet;
    private Node middleNode;
    private Node detachedNode;
    private Way extraWay;

    public CorridorGeography(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    private void setExtraElements(CorridorPart.ReachableSide side, LatLon from, LatLon to, boolean extraWayUp) {
        LatLon middleCoor = new LatLon((from.lat() + to.lat()) / 2.0, (from.lon() + to.lon()) / 2.0);
        if (this.middleNode == null) {
            this.middleNode = new Node(middleCoor);
            this.dataSet.addPrimitive((OsmPrimitive)this.middleNode);
        } else {
            this.middleNode.setCoor(middleCoor);
        }
        LatLon start = from;
        if (side == CorridorPart.ReachableSide.LEFT) {
            if (middleCoor.lat() < start.lat()) {
                start = to;
            }
        } else if (side == CorridorPart.ReachableSide.RIGHT) {
            if (start.lat() < middleCoor.lat()) {
                start = to;
            }
        } else if (side == CorridorPart.ReachableSide.FRONT) {
            if (start.lon() < middleCoor.lon()) {
                start = to;
            }
        } else if (side == CorridorPart.ReachableSide.BACK && middleCoor.lon() < start.lon()) {
            start = to;
        }
        double scale = Math.cos(middleCoor.lat() * (Math.PI / 180));
        LatLon detachedCoor = new LatLon(middleCoor.lat() + (start.lon() - middleCoor.lon()) * scale, middleCoor.lon() - (start.lat() - middleCoor.lat()) / scale);
        if (this.detachedNode == null) {
            this.detachedNode = new Node(detachedCoor);
            this.dataSet.addPrimitive((OsmPrimitive)this.detachedNode);
        } else {
            this.detachedNode.setCoor(detachedCoor);
        }
        Vector<Node> extraWayNodes = new Vector<Node>();
        if (extraWayUp) {
            extraWayNodes.add(this.middleNode);
            extraWayNodes.add(this.detachedNode);
        } else {
            extraWayNodes.add(this.detachedNode);
            extraWayNodes.add(this.middleNode);
        }
        if (this.extraWay == null) {
            this.extraWay = new Way();
            this.extraWay.setNodes(extraWayNodes);
            this.dataSet.addPrimitive((OsmPrimitive)this.extraWay);
        } else {
            this.extraWay.setNodes(extraWayNodes);
        }
    }

    public void appendNodes(CorridorPart.Type type, CorridorPart.ReachableSide side, String level, LatLon from, LatLon to, ModelGeography target) {
        if (type == CorridorPart.Type.STAIRS_UP || type == CorridorPart.Type.STAIRS_DOWN) {
            this.setExtraElements(side, from, to, type == CorridorPart.Type.STAIRS_UP);
            target.appendNode(this.middleNode);
            this.detachedNode.removeAll();
            this.extraWay.removeAll();
            this.extraWay.put("highway", "steps");
            this.extraWay.put("incline", "up");
            this.extraWay.put("level", level);
        } else if (type == CorridorPart.Type.ESCALATOR_UP_LEAVING || type == CorridorPart.Type.ESCALATOR_UP_ARRIVING || type == CorridorPart.Type.ESCALATOR_UP_BIDIRECTIONAL || type == CorridorPart.Type.ESCALATOR_DOWN_LEAVING || type == CorridorPart.Type.ESCALATOR_DOWN_ARRIVING || type == CorridorPart.Type.ESCALATOR_DOWN_BIDIRECTIONAL) {
            this.setExtraElements(side, from, to, type == CorridorPart.Type.ESCALATOR_UP_LEAVING || type == CorridorPart.Type.ESCALATOR_UP_ARRIVING || type == CorridorPart.Type.ESCALATOR_UP_BIDIRECTIONAL);
            target.appendNode(this.middleNode);
            this.detachedNode.removeAll();
            this.extraWay.removeAll();
            this.extraWay.put("highway", "steps");
            this.extraWay.put("incline", "up");
            if (type == CorridorPart.Type.ESCALATOR_UP_LEAVING || type == CorridorPart.Type.ESCALATOR_DOWN_ARRIVING) {
                this.extraWay.put("conveying", "forward");
            } else if (type == CorridorPart.Type.ESCALATOR_UP_ARRIVING || type == CorridorPart.Type.ESCALATOR_DOWN_LEAVING) {
                this.extraWay.put("conveying", "backward");
            } else {
                this.extraWay.put("conveying", "reversible");
            }
            this.extraWay.put("level", level);
        } else if (type == CorridorPart.Type.ELEVATOR) {
            this.setExtraElements(side, from, to, true);
            target.appendNode(this.middleNode);
            this.detachedNode.removeAll();
            this.detachedNode.put("highway", "elevator");
            this.extraWay.removeAll();
            this.extraWay.put("highway", "footway");
            this.extraWay.put("level", level);
        } else {
            if (this.extraWay != null) {
                this.extraWay.setDeleted(true);
                this.extraWay = null;
            }
            if (this.middleNode != null) {
                this.middleNode.setDeleted(true);
                this.middleNode = null;
            }
            if (this.detachedNode != null) {
                this.detachedNode.setDeleted(true);
                this.detachedNode = null;
            }
        }
    }
}

