/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.i18n;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18n {
    private ResourceBundle bundle;
    private ResourceBundle setBundle;
    private Locale sourceCodeLocale = Locale.ENGLISH;
    private String baseName;
    private ClassLoader loader;
    static /* synthetic */ Class class$java$lang$String;

    public I18n(ResourceBundle bundle) {
        this.setResources(bundle);
    }

    public I18n(String baseName, Locale locale, ClassLoader loader) {
        this.setResources(baseName, locale, loader);
    }

    public ResourceBundle getResources() {
        return this.setBundle;
    }

    public void setResources(ResourceBundle newBundle) {
        this.setBundle = newBundle;
        this.bundle = this.setBundle.getKeys().hasMoreElements() ? this.setBundle : this.setBundle;
        this.baseName = null;
        this.loader = null;
    }

    public void setResources(String baseName, Locale locale, ClassLoader loader) {
        this.setResources(ResourceBundle.getBundle(baseName, locale, loader));
        this.baseName = baseName;
        this.loader = loader;
    }

    public static final String marktr(String text) {
        return text;
    }

    public boolean setLocale(Locale locale) {
        if (this.baseName != null && this.loader != null) {
            this.setResources(this.baseName, locale, this.loader);
            return true;
        }
        return false;
    }

    public void setSourceCodeLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale must not be null");
        }
        this.sourceCodeLocale = locale;
    }

    public final String tr(String text) {
        try {
            return this.bundle.getString(text);
        }
        catch (MissingResourceException e) {
            return text;
        }
    }

    public final String tr(String text, Object[] objects) {
        return MessageFormat.format(this.tr(text), objects);
    }

    public final String tr(String text, Object o1) {
        return this.tr(text, new Object[]{o1});
    }

    public final String tr(String text, Object o1, Object o2) {
        return this.tr(text, new Object[]{o1, o2});
    }

    public final String tr(String text, Object o1, Object o2, Object o3) {
        return this.tr(text, new Object[]{o1, o2, o3});
    }

    public final String tr(String text, Object o1, Object o2, Object o3, Object o4) {
        return this.tr(text, new Object[]{o1, o2, o3, o4});
    }

    public final String trn(String text, String pluralText, long n) {
        try {
            return I18n.trnInternal(this.bundle, text, pluralText, n);
        }
        catch (MissingResourceException e) {
            return n == 1L ? text : pluralText;
        }
    }

    public final String trn(String text, String pluralText, long n, Object[] objects) {
        return MessageFormat.format(this.trn(text, pluralText, n), objects);
    }

    public final String trn(String text, String pluralText, long n, Object o1) {
        return this.trn(text, pluralText, n, new Object[]{o1});
    }

    public final String trn(String text, String pluralText, long n, Object o1, Object o2) {
        return this.trn(text, pluralText, n, new Object[]{o1, o2});
    }

    public final String trn(String text, String pluralText, long n, Object o1, Object o2, Object o3) {
        return this.trn(text, pluralText, n, new Object[]{o1, o2, o3});
    }

    public final String trn(String text, String pluralText, long n, Object o1, Object o2, Object o3, Object o4) {
        return this.trn(text, pluralText, n, new Object[]{o1, o2, o3, o4});
    }

    private static String trnInternal(ResourceBundle orgBundle, String text, String pluralText, long n) {
        ResourceBundle bundle = orgBundle;
        do {
            boolean isGetTextBundle = false;
            boolean hasPluralHandling = false;
            Method handleGetObjectMethod = null;
            Method getParentMethod = null;
            Method lookupMethod = null;
            Method pluralEvalMethod = null;
            try {
                handleGetObjectMethod = bundle.getClass().getMethod("handleGetObject", class$java$lang$String == null ? I18n.class$("java.lang.String") : class$java$lang$String);
                getParentMethod = bundle.getClass().getMethod("getParent", new Class[0]);
                isGetTextBundle = Modifier.isPublic(handleGetObjectMethod.getModifiers());
                lookupMethod = bundle.getClass().getMethod("lookup", class$java$lang$String == null ? I18n.class$("java.lang.String") : class$java$lang$String);
                pluralEvalMethod = bundle.getClass().getMethod("pluralEval", Long.TYPE);
                hasPluralHandling = true;
            }
            catch (Exception e) {
                // empty catch block
            }
            if (isGetTextBundle) {
                Object localValue;
                if (hasPluralHandling) {
                    try {
                        localValue = lookupMethod.invoke((Object)bundle, text);
                        if (localValue.getClass().isArray()) {
                            String[] pluralforms = (String[])localValue;
                            long index = 0L;
                            try {
                                index = (Long)pluralEvalMethod.invoke((Object)bundle, new Long(n));
                                if (index < 0L || index >= (long)pluralforms.length) {
                                    index = 0L;
                                }
                            }
                            catch (IllegalAccessException e) {
                                // empty catch block
                            }
                            return pluralforms[(int)index];
                        }
                        return (String)localValue;
                    }
                    catch (Exception e) {}
                } else {
                    try {
                        localValue = handleGetObjectMethod.invoke((Object)bundle, text);
                        if (localValue != null) {
                            return (String)localValue;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                bundle = null;
                try {
                    bundle = (ResourceBundle)getParentMethod.invoke((Object)bundle, new Object[0]);
                }
                catch (Exception e) {}
                continue;
            }
            return bundle.getString(text);
        } while (bundle != null);
        throw new MissingResourceException("Can not find resource for key " + text + " in bundle " + orgBundle.getClass().getName(), orgBundle.getClass().getName(), text);
    }

    public final String trc(String comment, String text) {
        return this.sourceCodeLocale.equals(this.getResources().getLocale()) ? text : this.tr(comment);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class EmptyResourceBundle
    extends ResourceBundle {
        private EmptyResourceBundle() {
        }

        protected Object handleGetObject(String key) {
            return key;
        }

        public Enumeration getKeys() {
            return new EmptyStringEnumeration();
        }

        private static class EmptyStringEnumeration
        implements Enumeration {
            private EmptyStringEnumeration() {
            }

            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() {
                throw new IllegalStateException("nextElement must not be called on empty enumeration");
            }
        }
    }
}

