/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.xml.elements;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.IXMLTestSuite;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.XMLTagResourceBundle;
import junit.extensions.xml.elements.AbstractTagHandler;
import org.w3c.dom.Element;

public class TagHandlersTagHandler
extends AbstractTagHandler {
    public TagHandlersTagHandler(Element element, IXMLTestCase testcase) {
        super(element, testcase);
    }

    public TagHandlersTagHandler(Element element, IXMLTestSuite testsuite) {
        super(element, testsuite);
    }

    public void processElement() throws XMLException {
        this.validateElement();
    }

    public void validateElement() throws XMLException {
        super.validateElement();
        this.checkRequiredAttribute("action");
        this.checkRequiredAttribute("tagname");
        String action = this.getString("action");
        String tagname = this.getString("tagname");
        if ("add".equals(action)) {
            this.checkRequiredAttribute("classname");
            String classname = this.getString("classname");
            try {
                Class<?> clz = Class.forName(classname);
            }
            catch (ClassNotFoundException ex) {
                throw new XMLException("Class not found:" + classname, (Throwable)ex, this.getElement(), null);
            }
            XMLTagResourceBundle.addTagHandler(tagname, classname);
        } else if ("remove".equals(action)) {
            XMLTagResourceBundle.removeTagHandler(tagname);
        } else {
            throw new XMLException("Invalid action:" + action, null, this.getElement(), null);
        }
    }
}

