/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.finder;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import junit.extensions.jfcunit.TestHelper;
import junit.extensions.jfcunit.finder.AbstractWindowFinder;
import junit.extensions.jfcunit.finder.Finder;
import junit.extensions.jfcunit.tools.Operator;
import junit.extensions.jfcunit.xml.JFCXMLConstants;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.elements.AbstractTagHandler;
import org.w3c.dom.Element;

public abstract class BaseFindTagHandler
extends AbstractTagHandler
implements JFCXMLConstants {
    public BaseFindTagHandler(Element element, IXMLTestCase testCase) {
        super(element, testCase);
    }

    public abstract void processElement() throws XMLException;

    public void validateElement() throws XMLException {
        super.validateElement();
        this.checkElementTagName("find");
        this.checkRequiredAttribute("id");
        this.checkRequiredAttribute("index");
    }

    protected final boolean getCaseIndependent() {
        return this.getBoolean("caseindependent");
    }

    protected final String getClassName() {
        return this.getString("class");
    }

    protected final String getContainerId() {
        return this.getString("container");
    }

    protected final Icon getIcon() {
        ImageIcon icon = null;
        String file = this.getString("iconfile");
        String desc = this.getString("icondesc");
        if (file != null && !file.equals("")) {
            icon = new ImageIcon(file, desc);
        }
        return icon;
    }

    protected final String getId() {
        return this.getString("id");
    }

    protected final int getIndex() {
        return this.getInt("index", 0);
    }

    protected final String getLabel() {
        return this.getString("label");
    }

    protected final String getName() {
        return this.getString("name");
    }

    protected final int getOperation() {
        String op = super.getString("operation");
        if (op == null || op.length() == 0) {
            return 0;
        }
        return Operator.Operation.getOperation(op);
    }

    protected final boolean getShow() {
        return this.getBoolean("show", false);
    }

    protected final String getTitle() {
        return this.getString("title");
    }

    protected int getWait() {
        return super.getInt("wait", 5);
    }

    protected void find(Finder finder) {
        Component comp;
        int index = this.getIndex();
        finder.setWait(this.getWait());
        finder.setShowDebug(this.getShow());
        String containerRefId = this.getContainerId();
        finder.setOperation(this.getOperation());
        if (containerRefId != null) {
            Container cont = (Container)this.getXMLTestCase().getProperty(containerRefId);
            if (cont instanceof JMenu) {
                cont = ((JMenu)cont).getPopupMenu();
            }
            comp = finder.find(cont, index);
        } else {
            comp = finder.find(index);
        }
        String id = this.getId();
        this.getXMLTestCase().addProperty(id, comp);
    }

    protected void findWindow(AbstractWindowFinder wfinder) {
        Window w = null;
        wfinder.setWait(this.getWait());
        wfinder.setOperation(this.getOperation());
        w = TestHelper.getWindow(wfinder);
        String id = this.getId();
        this.getXMLTestCase().addProperty(id, w);
    }
}

