/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.xml;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLWriter {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String LEXICAL_HANDLER_PROPERTY_ID = "http://xml.org/sax/properties/lexical-handler";
    protected static final String DEFAULT_PARSER_NAME = "dom.wrappers.Xerces";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_CANONICAL = false;
    private PrintWriter m_fOut;
    private boolean m_fCanonical;

    public XMLWriter() {
    }

    public XMLWriter(boolean canonical) {
        this.m_fCanonical = canonical;
    }

    public void setCanonical(boolean canonical) {
        this.m_fCanonical = canonical;
    }

    public boolean getCanonical() {
        return this.m_fCanonical;
    }

    public void setOutput(Writer writer) {
        this.m_fOut = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void setOutput(OutputStream stream, String encoding) throws UnsupportedEncodingException {
        String enc = encoding;
        if (enc == null) {
            enc = "UTF8";
        }
        OutputStreamWriter writer = new OutputStreamWriter(stream, enc);
        this.setOutput(writer);
    }

    public void write(Node node) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                this.processDocument(node);
                break;
            }
            case 10: {
                this.processDocumentType(node);
                break;
            }
            case 1: {
                this.processElement(type, node);
                break;
            }
            case 5: {
                this.processEntityRef(node);
                break;
            }
            case 4: {
                this.processCData(node);
                break;
            }
            case 3: {
                this.processText(node);
                break;
            }
            case 8: {
                this.processComment(node);
                break;
            }
            case 7: {
                this.processInstructions(node);
                break;
            }
            default: {
                this.processOther(node);
            }
        }
    }

    protected void normalizeAndPrint(String s) {
        int len = 0;
        if (s != null) {
            len = s.length();
        }
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            this.normalizeAndPrint(c);
        }
    }

    protected void normalizeAndPrint(char c) {
        switch (c) {
            case '<': {
                this.m_fOut.print("&lt;");
                break;
            }
            case '>': {
                this.m_fOut.print("&gt;");
                break;
            }
            case '&': {
                this.m_fOut.print("&amp;");
                break;
            }
            case '\"': {
                this.m_fOut.print("&quot;");
                break;
            }
            case '\n': 
            case '\r': {
                if (this.m_fCanonical) {
                    this.m_fOut.print("&#");
                    this.m_fOut.print(Integer.toString(c));
                    this.m_fOut.print(';');
                    break;
                }
            }
            default: {
                this.m_fOut.print(c);
            }
        }
    }

    protected Attr[] sortAttributes(NamedNodeMap attrs) {
        int i;
        int len = 0;
        if (attrs != null) {
            len = attrs.getLength();
        }
        Attr[] array = new Attr[len];
        for (i = 0; i < len; ++i) {
            array[i] = (Attr)attrs.item(i);
        }
        for (i = 0; i < len - 1; ++i) {
            String name = array[i].getNodeName();
            int index = i;
            for (int j = i + 1; j < len; ++j) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) >= 0) continue;
                name = curName;
                index = j;
            }
            if (index == i) continue;
            Attr temp = array[i];
            array[i] = array[index];
            array[index] = temp;
        }
        return array;
    }

    private void processCData(Node node) {
        if (this.m_fCanonical) {
            this.normalizeAndPrint(node.getNodeValue());
        } else {
            this.m_fOut.print("<![CDATA[");
            this.m_fOut.print(node.getNodeValue());
            this.m_fOut.print("]]>");
        }
        this.m_fOut.flush();
    }

    private void processComment(Node node) {
        this.m_fOut.print("<!-- ");
        this.m_fOut.print(node.getNodeValue());
        this.m_fOut.print(" -->");
    }

    private void processDocument(Node node) {
        Document document = (Document)node;
        if (!this.m_fCanonical) {
            this.m_fOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.m_fOut.flush();
            this.write(document.getDoctype());
        }
        NodeList list = document.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            this.write(list.item(i));
        }
    }

    private void processDocumentType(Node node) {
        DocumentType doctype = (DocumentType)node;
        this.m_fOut.print("<!DOCTYPE ");
        this.m_fOut.print(doctype.getName());
        String publicId = doctype.getPublicId();
        String systemId = doctype.getSystemId();
        if (publicId != null) {
            this.m_fOut.print(" PUBLIC '");
            this.m_fOut.print(publicId);
            this.m_fOut.print("' '");
            this.m_fOut.print(systemId);
            this.m_fOut.print('\'');
        } else {
            this.m_fOut.print(" SYSTEM '");
            this.m_fOut.print(systemId);
            this.m_fOut.print('\'');
        }
        String internalSubset = doctype.getInternalSubset();
        if (internalSubset != null) {
            this.m_fOut.println(" [");
            this.m_fOut.print(internalSubset);
            this.m_fOut.print(']');
        }
        this.m_fOut.println('>');
    }

    private void processElement(short type, Node node) {
        this.m_fOut.print('<');
        this.m_fOut.print(node.getNodeName());
        Attr[] attrs = this.sortAttributes(node.getAttributes());
        for (int i = 0; i < attrs.length; ++i) {
            Attr attr = attrs[i];
            String name = attr.getNodeName();
            if ("JFCFileLocation".equals(name)) continue;
            this.m_fOut.print(' ');
            this.m_fOut.print(attr.getNodeName());
            this.m_fOut.print("=\"");
            this.normalizeAndPrint(attr.getNodeValue());
            this.m_fOut.print('\"');
        }
        NodeList children = node.getChildNodes();
        if (children.getLength() == 0) {
            this.m_fOut.print("/>");
            this.m_fOut.flush();
        } else {
            this.m_fOut.print('>');
            this.m_fOut.flush();
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.write(child);
            }
            if (type == 1) {
                this.m_fOut.print("</");
                this.m_fOut.print(node.getNodeName());
                this.m_fOut.print('>');
                this.m_fOut.flush();
            }
        }
    }

    private void processEntityRef(Node node) {
        if (this.m_fCanonical) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.write(child);
            }
        } else {
            this.m_fOut.print('&');
            this.m_fOut.print(node.getNodeName());
            this.m_fOut.print(';');
            this.m_fOut.flush();
        }
    }

    private void processInstructions(Node node) {
        this.m_fOut.print("<?");
        this.m_fOut.print(node.getNodeName());
        String data = node.getNodeValue();
        if (data != null && data.length() > 0) {
            this.m_fOut.print(' ');
            this.m_fOut.print(data);
        }
        this.m_fOut.println("?>");
        this.m_fOut.flush();
    }

    private void processOther(Node node) {
    }

    private void processText(Node node) {
        this.normalizeAndPrint(node.getNodeValue());
        this.m_fOut.flush();
    }
}

