/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.xml;

import junit.extensions.xml.IXMLProcedure;
import junit.extensions.xml.IXMLTest;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLConstants;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.XMLObjectCache;
import junit.extensions.xml.XMLPropertyCache;
import junit.extensions.xml.XMLTagResourceBundle;
import junit.extensions.xml.XMLTestSuite;
import junit.extensions.xml.XMLUtil;
import junit.framework.Test;
import junit.framework.TestCase;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class XMLTestCase
extends TestCase
implements IXMLTestCase,
XMLConstants {
    private Element m_element;
    private IXMLTest m_parent;
    private String m_filename;
    private XMLObjectCache m_procedures = new XMLObjectCache();
    private XMLPropertyCache m_properties = new XMLPropertyCache();

    public XMLTestCase(String filename, Element element) {
        super(filename + ":" + XMLUtil.getPath(element));
        this.m_filename = filename;
        this.m_element = element;
    }

    public final boolean getDebug() {
        Object str = this.getProperty("debug");
        if (str instanceof String) {
            return Boolean.valueOf((String)str);
        }
        if (str instanceof Boolean) {
            return (Boolean)str;
        }
        return this.m_properties.get("debug") != null;
    }

    public final void setParent(IXMLTest parent) {
        this.m_parent = parent;
        this.m_properties.setParent(parent.getPropertyCache());
        this.m_procedures.setParent(parent.getProcedureCache());
    }

    public final IXMLProcedure getProcedure(String name) {
        return (IXMLProcedure)this.m_procedures.get(name);
    }

    public final XMLObjectCache getProcedureCache() {
        return this.m_procedures;
    }

    public final Object getProperty(String name) {
        return this.m_properties.get(name);
    }

    public final XMLObjectCache getPropertyCache() {
        return this.m_properties;
    }

    public final String getPropertyName(Object comp) {
        return this.m_properties.getName(comp);
    }

    public final String[] getPropertyNames() {
        return this.m_properties.getNames();
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public final void addProcedure(IXMLProcedure proc) {
        this.m_procedures.put(proc.getName(), proc);
    }

    public final void callProcedure(String name, Element element) throws XMLException {
        XMLPropertyCache cache = this.m_properties;
        this.m_properties = new XMLPropertyCache();
        this.m_properties.setParent(cache);
        NamedNodeMap atts = element.getAttributes();
        int size = atts.getLength();
        for (int i = 0; i < size; ++i) {
            Attr node = (Attr)atts.item(i);
            String an = node.getName();
            if ("call".equals(an)) continue;
            String value = XMLUtil.getAttribute(element, an);
            value = this.resolveProperties(value);
            this.addProperty(an, value);
        }
        IXMLProcedure proc = this.getProcedure(name);
        this.processChildren(proc.getElement());
        this.m_properties.setParent(null);
        this.m_properties = cache;
    }

    public final void processChildren(Element element) throws XMLException {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            Element child = (Element)children.item(i);
            String name = child.getTagName();
            try {
                XMLTagResourceBundle.getTagHandler(child, this, name).processElement();
            }
            catch (XMLException xe) {
                throw xe;
            }
            catch (Throwable t) {
                throw new XMLException(t.getMessage(), t, child, this.getPropertyCache());
            }
            if (child == children.item(i)) continue;
            while (child != children.item(i) && i < children.getLength()) {
                ++i;
            }
            if (i != children.getLength()) continue;
            throw new XMLException("Lost where we were at current node was removed.", null, this.m_element, this.getPropertyCache());
        }
    }

    public final void removeProperty(String name) {
        this.m_properties.remove(name);
    }

    public final String resolveProperties(String s) {
        return this.m_properties.resolve(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        this.setUp();
        try {
            this.runTest();
        }
        finally {
            this.tearDown();
        }
    }

    public final void runXMLTest() throws Exception {
        this.clearProperties();
        boolean debug = XMLUtil.getBooleanAttributeValue(this.m_element, "debug");
        if (debug) {
            this.m_properties.put("debug", Boolean.TRUE);
        } else {
            this.m_properties.remove("debug");
        }
        this.processChildren(this.m_element);
    }

    public static Test suite() {
        return new XMLTestSuite();
    }

    public final void addProperty(String name, Object obj) {
        this.m_properties.put(name, obj);
    }

    public final void clearProperties() {
        this.m_properties.clear();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    protected void runTest() throws Throwable {
        this.runXMLTest();
    }
}

