/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.xml.elements;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.XMLTagResourceBundle;
import junit.extensions.xml.elements.AbstractTagHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChooseTagHandler
extends AbstractTagHandler {
    private String m_choose;
    private String m_other;
    private String m_when;

    public ChooseTagHandler(Element element, IXMLTestCase testCase) {
        super(element, testCase);
    }

    public void processElement() throws XMLException {
        this.validateElement();
        NodeList nodes = this.getElement().getChildNodes();
        Element otherwise = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            if (this.m_when.equals(node.getNodeName())) {
                boolean result = false;
                Element e = (Element)node;
                try {
                    XMLTagResourceBundle.getTagHandler(e, this.getXMLTestCase(), this.getString(e, "test")).processElement();
                    result = true;
                    otherwise = null;
                }
                catch (XMLException xe) {
                    throw xe;
                }
                catch (Throwable t) {
                    result = false;
                }
                if (!result) continue;
                this.getXMLTestCase().processChildren(e);
                return;
            }
            if (!this.m_other.equals(node.getNodeName())) continue;
            otherwise = (Element)node;
        }
        if (otherwise != null) {
            this.getXMLTestCase().processChildren(otherwise);
            return;
        }
    }

    public void validateElement() throws XMLException {
        this.setChoose("choose");
        this.setWhen("when");
        this.setOther("otherwise");
        super.checkElementTagName(this.m_choose);
    }

    protected void setChoose(String choose) {
        this.m_choose = choose;
    }

    protected void setOther(String other) {
        this.m_other = other;
    }

    protected void setWhen(String when) {
        this.m_when = when;
    }
}

