/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.tools;

import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public final class Operator {
    private static Object s_lock = new Object();
    private static String s_cachePattern = null;
    private static RE s_cacheRE = null;

    private Operator() {
    }

    public static boolean evaluate(String leftside, String rightside, int operation, boolean ignoreCase) {
        String left = leftside;
        String right = rightside;
        if (left == null) {
            return right == null;
        }
        if (ignoreCase) {
            if (left != null) {
                left = left.toUpperCase();
            }
            if (right != null) {
                right = right.toUpperCase();
            }
        }
        if (operation == 4) {
            return left.indexOf(right) >= 0;
        }
        if (operation == 2) {
            return left.endsWith(right);
        }
        if (operation == 1) {
            return left.startsWith(right);
        }
        if (operation == 3) {
            return left.equals(right);
        }
        if (operation == 0) {
            return Operator.matchPattern(left, right);
        }
        throw new IllegalStateException("Invalid operation for finder:" + operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RE getPattern(String pattern) {
        Object object = s_lock;
        synchronized (object) {
            if (pattern != null && pattern.equals(s_cachePattern)) {
                return s_cacheRE;
            }
            try {
                s_cachePattern = pattern;
                s_cacheRE = pattern == null ? new RE("") : new RE(pattern);
            }
            catch (RESyntaxException ex) {
                s_cacheRE = null;
            }
        }
        return s_cacheRE;
    }

    private static boolean matchPattern(String componentAttribute, String patternString) {
        RE re = Operator.getPattern(patternString);
        boolean value = re.match(componentAttribute);
        return componentAttribute != null && re != null && value;
    }

    public static final class Operation {
        private static final String[] CODE_STRINGS = new String[]{"match", "startswith", "endswith", "equals", "contains"};
        public static final int MATCH = 0;
        public static final int STARTSWITH = 1;
        public static final int ENDSWITH = 2;
        public static final int EQUALS = 3;
        public static final int CONTAINS = 4;

        private Operation() {
        }

        public static int getOperation(String code) {
            for (int i = 0; i < CODE_STRINGS.length; ++i) {
                if (!CODE_STRINGS[i].equalsIgnoreCase(code)) continue;
                return i;
            }
            throw new IllegalArgumentException("Operation not found:" + code);
        }

        public static String toString(int code) {
            if (code < 0 || code >= CODE_STRINGS.length) {
                throw new IllegalArgumentException("Invalid Operation code:" + code);
            }
            return CODE_STRINGS[code];
        }
    }
}

