/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import javax.swing.JTree;
import javax.swing.tree.TreePath;
import junit.extensions.jfcunit.eventdata.BaseEventDataTagHandler;
import junit.extensions.jfcunit.eventdata.JTreeMouseEventData;
import junit.extensions.jfcunit.eventdata.PathData;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import org.w3c.dom.Element;

public class JTreeMouseEventDataTagHandler
extends BaseEventDataTagHandler {
    public JTreeMouseEventDataTagHandler(Element element, IXMLTestCase testCase) {
        super(element, testCase);
    }

    public void processElement() throws XMLException {
        this.validateElement();
        JTree tree = (JTree)this.getComponent();
        if (this.getNodeValue() != null) {
            this.setEventData(new JTreeMouseEventData(this.getJFCTestCase(), tree, this.getNodeValue(), this.getClicks(), this.getModifiers(), this.getPopupTrigger(), this.getSleepTime(), this.getPosition(), this.getReference()));
        } else {
            String id = this.getPathRefid();
            Object pathdata = this.getTest().getProperty(id);
            if (pathdata instanceof PathData) {
                TreePath path = ((PathData)pathdata).getTreePath(tree);
                this.setEventData(new JTreeMouseEventData(this.getJFCTestCase(), tree, path, this.getClicks(), this.getModifiers(), this.getPopupTrigger(), this.getSleepTime(), this.getPosition(), this.getReference()));
            } else {
                throw new XMLException("pathrefid point to object which is not a PathData", this.getElement());
            }
        }
    }

    public void validateElement() throws XMLException {
        super.validateElement();
        this.checkOneRequiredAttribute(new String[]{"node", "pathrefid"});
    }

    private String getNodeValue() {
        return this.getString("node");
    }

    private String getPathRefid() {
        return this.getString("pathrefid");
    }
}

