/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tracer2;

import java.awt.geom.Point2D;

public class StraightLine {
    private Double m_dm;
    private Double m_dc;
    private Double m_dx;
    private Double m_dAlpha;

    public StraightLine(Double dm, Double dc, boolean bRevert) {
        this.m_dm = dm;
        this.m_dc = dc;
        this.m_dx = Double.NaN;
        this.m_dAlpha = this.m_dm.isNaN() ? Double.valueOf(Double.NaN) : (this.m_dm.isInfinite() ? StraightLine.CheckAlpha(Double.NEGATIVE_INFINITY == this.m_dm ? -90.0 : 90.0) : StraightLine.CheckAlpha(Math.atan(dm) * 180.0 / Math.PI + (double)(bRevert ? 180 : 0)));
    }

    public StraightLine(Point2D.Double oP1, Point2D.Double oP2) {
        this.m_dm = (oP2.getY() - oP1.getY()) / (oP2.getX() - oP1.getX());
        this.m_dc = oP1.getY() - this.m_dm * oP1.getX();
        if (this.m_dm.isInfinite() || this.m_dm.isNaN()) {
            this.m_dx = oP1.getX();
            this.m_dAlpha = StraightLine.CheckAlpha(oP1.getY() > oP2.getY() ? -90.0 : 90.0);
        } else {
            this.m_dx = Double.NaN;
            this.m_dAlpha = StraightLine.CheckAlpha(Math.atan((oP2.getY() - oP1.getY()) / (oP2.getX() - oP1.getX())) * 180.0 / Math.PI + (double)(oP1.getX() > oP2.getX() ? 180 : 0));
        }
    }

    private static Double CheckAlpha(Double dAlpha) {
        if (dAlpha > 180.0) {
            return dAlpha - 360.0;
        }
        if (dAlpha <= -180.0) {
            return dAlpha + 360.0;
        }
        return dAlpha;
    }

    public Double getM() {
        return this.m_dm;
    }

    public Double getC() {
        return this.m_dc;
    }

    public Double getX() {
        return this.m_dx;
    }

    public Double getAlpha() {
        return this.m_dAlpha;
    }

    public boolean IsLine() {
        return !this.m_dx.isNaN() && !this.m_dx.isInfinite() && !this.m_dAlpha.isNaN() && !this.m_dAlpha.isInfinite() || !this.m_dm.isNaN() && !this.m_dm.isInfinite() && !this.m_dc.isNaN() && !this.m_dc.isInfinite();
    }

    public Point2D.Double GetIntersectionPoint(StraightLine oLine) {
        Double dy;
        Double dx;
        if (!this.IsLine() || !oLine.IsLine()) {
            return new Point2D.Double(Double.NaN, Double.NaN);
        }
        if (this.m_dm.isInfinite() || this.m_dm.isNaN()) {
            if (oLine.getM().isInfinite() || oLine.getM().isNaN()) {
                return new Point2D.Double(Double.NaN, Double.NaN);
            }
            dx = this.m_dx;
            dy = oLine.getM() * dx + oLine.getC();
        } else if (oLine.getM().isInfinite() || oLine.getM().isNaN()) {
            dx = oLine.getX();
            dy = this.m_dm * dx + this.m_dc;
        } else {
            dx = (oLine.m_dc - this.m_dc) / (this.m_dm - oLine.m_dm);
            dy = this.m_dm * dx + this.m_dc;
        }
        return new Point2D.Double(dx, dy);
    }
}

