/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.traffico;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapillary.traffico.TrafficoGlyph;
import org.openstreetmap.josm.plugins.mapillary.traffico.TrafficoSignElement;

public final class TrafficoSign {
    private static Map<String, Map<String, TrafficoSignElement[]>> signs = new HashMap<String, Map<String, TrafficoSignElement[]>>();

    private TrafficoSign() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static TrafficoSignElement[] getSign(String country, String signName) {
        if (signs.get(country) == null) {
            Main.info((String)"Reading signs for country ''{0}''.", (Object[])new Object[]{country});
            try (InputStream countryStream = TrafficoSign.class.getResourceAsStream("/data/fonts/traffico/signs/" + country + ".json");){
                if (countryStream == null) {
                    TrafficoSignElement[] trafficoSignElementArray = null;
                    return trafficoSignElementArray;
                }
                JsonObject countrySigns = Json.createReader((InputStream)countryStream).readObject();
                Set countrySignNames = countrySigns.keySet();
                Main.info((String)(countrySignNames.size() + " different signs are supported for ''{0}'' by the Mapillary-plugin ."), (Object[])new Object[]{country});
                HashMap<String, TrafficoSignElement[]> countryMap = new HashMap<String, TrafficoSignElement[]>();
                for (String name : countrySignNames) {
                    JsonArray elements = countrySigns.getJsonObject(name).getJsonArray("elements");
                    ArrayList<TrafficoSignElement> layers = new ArrayList<TrafficoSignElement>();
                    for (int i = 0; i < elements.size(); ++i) {
                        Color c;
                        Character glyph = TrafficoGlyph.getGlyph(elements.getJsonObject(i).getString("type"));
                        if (glyph == null) continue;
                        switch (elements.getJsonObject(i).getString("color").toLowerCase()) {
                            case "black": {
                                c = Color.BLACK;
                                break;
                            }
                            case "red": {
                                c = Color.RED;
                                break;
                            }
                            case "blue": {
                                c = Color.BLUE;
                                break;
                            }
                            case "white": {
                                c = Color.WHITE;
                                break;
                            }
                            case "green": {
                                c = Color.GREEN;
                                break;
                            }
                            case "yellow": {
                                c = Color.YELLOW;
                                break;
                            }
                            default: {
                                c = Color.MAGENTA;
                            }
                        }
                        layers.add(new TrafficoSignElement(glyph.charValue(), c));
                    }
                    countryMap.put(name, layers.toArray(new TrafficoSignElement[layers.size()]));
                }
                signs.put(country, countryMap);
            }
            catch (IOException e) {
                Main.error((Throwable)e);
            }
        }
        if (signs.get(country).get(signName) != null) {
            return signs.get(country).get(signName);
        }
        return null;
    }
}

