/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.mode;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.util.Calendar;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.io.download.MapillaryDownloader;

public abstract class AbstractMode
extends MouseAdapter
implements NavigatableComponent.ZoomChangeListener {
    private static final int DOWNLOAD_COOLDOWN = 2000;
    protected MapillaryData data = MapillaryLayer.getInstance().getData();
    private static SemiautomaticThread semiautomaticThread = new SemiautomaticThread();
    public int cursor = 0;

    protected MapillaryAbstractImage getClosest(Point clickPoint) {
        double snapDistance = 10.0;
        double minDistance = Double.MAX_VALUE;
        MapillaryAbstractImage closest = null;
        for (MapillaryAbstractImage image : this.data.getImages()) {
            Point imagePoint = Main.map.mapView.getPoint(image.getLatLon());
            imagePoint.setLocation(imagePoint.getX(), imagePoint.getY());
            double dist = clickPoint.distanceSq(imagePoint);
            if (!(minDistance > dist) || !(clickPoint.distance(imagePoint) < snapDistance) || !image.isVisible()) continue;
            minDistance = dist;
            closest = image;
        }
        return closest;
    }

    public abstract void paint(Graphics2D var1, MapView var2, Bounds var3);

    public void zoomChanged() {
        if (MapillaryDownloader.getMode() == MapillaryDownloader.MODES.Semiautomatic) {
            if (!semiautomaticThread.isAlive()) {
                semiautomaticThread.start();
            }
            semiautomaticThread.moved();
        }
    }

    public static void resetThread() {
        semiautomaticThread.interrupt();
        semiautomaticThread = new SemiautomaticThread();
    }

    private static class SemiautomaticThread
    extends Thread {
        private long lastDownload;
        private boolean moved;

        private SemiautomaticThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                if (this.moved && Calendar.getInstance().getTimeInMillis() - this.lastDownload >= 2000L) {
                    this.lastDownload = Calendar.getInstance().getTimeInMillis();
                    MapillaryDownloader.completeView();
                    this.moved = false;
                    MapillaryData.dataUpdated();
                }
                SemiautomaticThread semiautomaticThread = this;
                synchronized (semiautomaticThread) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        public void moved() {
            this.moved = true;
        }
    }
}

