/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.io.download;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.io.download.MapillarySquareDownloadManagerThread;
import org.openstreetmap.josm.tools.I18n;

public final class MapillaryDownloader {
    private static List<Thread> threads = new ArrayList<Thread>();
    public static final double MAX_AREA = Main.pref.getDouble("mapillary.max-download-area", 0.015);
    private static ThreadPoolExecutor executor = new ThreadPoolExecutor(3, 5, 100L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));

    private MapillaryDownloader() {
    }

    public static void getImages(LatLon minLatLon, LatLon maxLatLon) {
        if (minLatLon == null || maxLatLon == null) {
            throw new IllegalArgumentException();
        }
        MapillaryDownloader.getImages(new Bounds(minLatLon, maxLatLon));
    }

    public static void getImages(Bounds bounds) {
        MapillaryDownloader.run(new MapillarySquareDownloadManagerThread(bounds));
    }

    public static MODES getMode() {
        boolean isTempSemiautomatic;
        String downloadMode = Main.pref.get("mapillary.download-mode", MODES.Automatic.toString());
        boolean bl = isTempSemiautomatic = MapillaryLayer.hasInstance() && MapillaryLayer.getInstance().tempSemiautomatic;
        if (MODES.Semiautomatic.toString().equals(downloadMode) || isTempSemiautomatic) {
            return MODES.Semiautomatic;
        }
        if (MODES.Manual.toString().equals(downloadMode)) {
            return MODES.Manual;
        }
        if (MODES.Automatic.toString().equals(downloadMode)) {
            return MODES.Automatic;
        }
        throw new IllegalStateException();
    }

    private static void run(Thread t) {
        threads.add(t);
        executor.execute(t);
    }

    public static void completeView() {
        if (MapillaryDownloader.getMode() != MODES.Semiautomatic && MapillaryDownloader.getMode() != MODES.Manual) {
            throw new IllegalStateException("Must be in semiautomatic or manual mode");
        }
        Bounds view = Main.map.mapView.getRealBounds();
        if (view.getArea() > MAX_AREA) {
            return;
        }
        if (MapillaryDownloader.isViewDownloaded(view)) {
            return;
        }
        MapillaryLayer.getInstance().getData().bounds.add(view);
        MapillaryDownloader.getImages(view);
    }

    private static boolean isViewDownloaded(Bounds view) {
        int j;
        int i;
        int n = 15;
        boolean[][] inside = new boolean[n][n];
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                if (!MapillaryDownloader.isInBounds(new LatLon(view.getMinLat() + (view.getMaxLat() - view.getMinLat()) * ((double)i / (double)n), view.getMinLon() + (view.getMaxLon() - view.getMinLon()) * ((double)j / (double)n)))) continue;
                inside[i][j] = true;
            }
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                if (inside[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isInBounds(LatLon latlon) {
        for (Bounds bounds : MapillaryLayer.getInstance().getData().bounds) {
            if (!bounds.contains(latlon)) continue;
            return true;
        }
        return false;
    }

    public static void automaticDownload() {
        MapillaryLayer layer = MapillaryLayer.getInstance();
        if (Main.map.mapView.getEditLayer() == null) {
            return;
        }
        if (MapillaryDownloader.isAreaTooBig()) {
            MapillaryDownloader.tooBigErrorDialog();
            return;
        }
        if (MapillaryDownloader.getMode() != MODES.Automatic) {
            throw new IllegalStateException("Must be in automatic mode.");
        }
        for (Bounds bounds : Main.map.mapView.getEditLayer().data.getDataSourceBounds()) {
            if (layer.getData().bounds.contains(bounds)) continue;
            layer.getData().bounds.add(bounds);
            MapillaryDownloader.getImages(bounds.getMin(), bounds.getMax());
        }
    }

    private static boolean isAreaTooBig() {
        double area = 0.0;
        for (Bounds bounds : Main.map.mapView.getEditLayer().data.getDataSourceBounds()) {
            area += bounds.getArea();
        }
        return area > MAX_AREA;
    }

    protected static void tooBigErrorDialog() {
        if (SwingUtilities.isEventDispatchThread()) {
            MapillaryLayer.getInstance().tempSemiautomatic = true;
            MapillaryPlugin.setMenuEnabled(MapillaryPlugin.getDownloadViewMenu(), true);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The downloaded OSM area is too big. Download mode has been changed to semiautomatic until the layer is restarted.", (Object[])new Object[0]));
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapillaryDownloader.tooBigErrorDialog();
                }
            });
        }
    }

    public static void stopAll() {
        for (Thread t : threads) {
            if (t.isAlive()) {
                Main.info((String)(t + " is still alive!"));
            }
            t.interrupt();
        }
        threads.clear();
        executor.shutdownNow();
        try {
            executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Main.error((Throwable)e);
        }
        executor = new ThreadPoolExecutor(3, 5, 100L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
    }

    public static enum MODES {
        Automatic,
        Semiautomatic,
        Manual;

    }
}

