/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.transport;

import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.ToulouseDataSetHandler;

public class StationsAutoPartageHandler
extends ToulouseDataSetHandler {
    public StationsAutoPartageHandler() {
        super(19163, "amenity=car_sharing");
        this.setName("Stations d'auto partage");
        this.setCategory(CAT_TRANSPORT);
        this.getCsvHandler().setCharset("ISO-8859-15");
    }

    public boolean acceptsFilename(String filename) {
        return this.acceptsCsvKmzTabFilename(filename, new String[]{"Autopartage"});
    }

    public void updateDataSet(DataSet ds) {
        for (Node n : ds.getNodes()) {
            n.put("amenity", "car_sharing");
            n.remove("Lib_voie");
            n.remove("mot_dir");
            n.remove("No");
            n.remove("commune");
            n.remove("code_insee");
            this.replace((IPrimitive)n, "id_AUTO", "ref:FR:ToulouseMetropole");
            this.replace((IPrimitive)n, "nb_places", "capacity");
            this.replace((IPrimitive)n, "arrete", "bylaw");
            this.replace((IPrimitive)n, "Societe", "operator");
            this.replace((IPrimitive)n, "annee", "start_date");
            n.remove("photo");
            this.replace((IPrimitive)n, "obervations", "note");
        }
    }
}

