/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.photoadjust;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.gui.layer.geoimage.ImageViewerDialog;

public class PhotoAdjustWorker {
    private ImageEntry dragPhoto = null;
    private GeoImageLayer dragLayer = null;
    private Point2D dragOffset = null;
    private boolean centerViewIsDisabled = false;
    private boolean centerViewNeedsEnable = false;

    public void reset() {
        this.dragPhoto = null;
        this.dragLayer = null;
        this.dragOffset = null;
    }

    public void disableCenterView() {
        if (!this.centerViewIsDisabled) {
            this.centerViewIsDisabled = true;
            this.centerViewNeedsEnable = ImageViewerDialog.setCentreEnabled((boolean)false);
        }
    }

    public void restoreCenterView() {
        if (this.centerViewIsDisabled) {
            if (this.centerViewNeedsEnable) {
                this.centerViewNeedsEnable = false;
                ImageViewerDialog.setCentreEnabled((boolean)true);
            }
            this.centerViewIsDisabled = false;
        }
    }

    public void doMousePressed(MouseEvent evt, List<GeoImageLayer> imageLayers) {
        this.reset();
        if (evt.getButton() == 1 && imageLayers != null && imageLayers.size() > 0) {
            boolean isCtrl;
            boolean isShift = (evt.getModifiers() & 1) != 0;
            boolean bl = isCtrl = (evt.getModifiers() & 2) != 0;
            if (isShift || isCtrl) {
                GeoImageLayer viewerLayer = ImageViewerDialog.getCurrentLayer();
                ImageEntry img = ImageViewerDialog.getCurrentImage();
                if (img != null && viewerLayer != null && viewerLayer.isVisible() && imageLayers.contains(viewerLayer)) {
                    if (isCtrl) {
                        if (img.getPos() != null) {
                            this.changeDirection(img, viewerLayer, evt);
                        }
                    } else {
                        this.movePhoto(img, viewerLayer, evt);
                    }
                    this.dragPhoto = img;
                    this.dragLayer = viewerLayer;
                }
            } else {
                for (GeoImageLayer layer : imageLayers) {
                    if (!layer.isVisible()) continue;
                    this.dragPhoto = layer.getPhotoUnderMouse(evt);
                    if (this.dragPhoto == null) continue;
                    this.dragLayer = layer;
                    this.setDragOffset(this.dragPhoto, evt);
                    this.disableCenterView();
                    break;
                }
            }
        }
    }

    public void doMouseReleased(MouseEvent evt) {
        this.restoreCenterView();
    }

    public void doMouseDragged(MouseEvent evt) {
        if (this.dragLayer != null && this.dragLayer.isVisible() && this.dragPhoto != null) {
            if ((evt.getModifiers() & 2) != 0) {
                this.changeDirection(this.dragPhoto, this.dragLayer, evt);
            } else {
                this.disableCenterView();
                this.movePhoto(this.dragPhoto, this.dragLayer, evt);
            }
        }
    }

    private void setDragOffset(ImageEntry photo, MouseEvent evt) {
        Point2D centerPoint = Main.map.mapView.getPoint2D((LatLon)photo.getPos());
        this.dragOffset = new Point2D.Double(centerPoint.getX() - (double)evt.getX(), centerPoint.getY() - (double)evt.getY());
    }

    private void movePhoto(ImageEntry photo, GeoImageLayer layer, MouseEvent evt) {
        LatLon newPos = this.dragOffset != null ? Main.map.mapView.getLatLon(this.dragOffset.getX() + (double)evt.getX(), this.dragOffset.getY() + (double)evt.getY()) : Main.map.mapView.getLatLon(evt.getX(), evt.getY());
        photo.setPos(newPos);
        photo.flagNewGpsData();
        layer.updateBufferAndRepaint();
        ImageViewerDialog.showImage((GeoImageLayer)layer, (ImageEntry)photo);
    }

    private void changeDirection(ImageEntry photo, GeoImageLayer layer, MouseEvent evt) {
        CachedLatLon photoLL = photo.getPos();
        if (photoLL == null) {
            return;
        }
        LatLon mouseLL = Main.map.mapView.getLatLon(evt.getX(), evt.getY());
        double direction = 360.0 - photoLL.heading(mouseLL) * 360.0 / 2.0 / Math.PI;
        if (direction < 0.0) {
            direction += 360.0;
        } else if (direction >= 360.0) {
            direction -= 360.0;
        }
        photo.setExifImgDir(Double.valueOf(direction));
        photo.flagNewGpsData();
        layer.updateBufferAndRepaint();
        ImageViewerDialog.showImage((GeoImageLayer)layer, (ImageEntry)photo);
        this.setDragOffset(photo, evt);
    }
}

