/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.be.bruxelles.datasets;

import java.net.MalformedURLException;
import java.net.URL;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.plugins.opendata.core.datasets.be.BelgianDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.util.OdUtils;
import org.openstreetmap.josm.plugins.opendata.modules.be.bruxelles.BruxellesConstants;

public abstract class BruxellesDataSetHandler
extends BelgianDataSetHandler
implements BruxellesConstants {
    private Integer localPortalId;

    public BruxellesDataSetHandler() {
        this.init(null, null);
    }

    public BruxellesDataSetHandler(Integer portalId) {
        this.init(portalId, null);
    }

    public BruxellesDataSetHandler(Integer portalId, Projection singleProjection) {
        this.init(portalId, singleProjection);
    }

    public BruxellesDataSetHandler(Integer portalId, Projection singleProjection, String relevantTag) {
        super(relevantTag);
        this.init(portalId, singleProjection);
    }

    public BruxellesDataSetHandler(Integer portalId, String relevantTag) {
        super(relevantTag);
        this.init(portalId, null);
    }

    private void init(Integer portalId, Projection singleProjection) {
        this.setSingleProjection(singleProjection);
        this.localPortalId = portalId;
    }

    public String getSource() {
        return "Ville de Bruxelles";
    }

    public URL getLocalPortalURL() {
        String basePortal = null;
        String lang = OdUtils.getJosmLanguage();
        basePortal = lang.startsWith("fr") ? "http://www.bruxelles.be" : (lang.startsWith("nl") ? "http://www.brussel.be" : "http://www.brussels.be");
        try {
            return new URL(basePortal + "/artdet.cfm?id=" + this.localPortalId);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

