/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.routes;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.plugins.routes.RemoveRelationMemberCommand;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class RelationEditMode
extends MapMode {
    private static final long serialVersionUID = -7767329767438266289L;
    private Way highlightedWay;

    public RelationEditMode(MapFrame mapFrame) {
        super(I18n.tr((String)"Edit relation", (Object[])new Object[0]), "node/autonode", I18n.tr((String)"Edit relations", (Object[])new Object[0]), Shortcut.registerShortcut((String)"mapmode:editRelation", (String)I18n.tr((String)"Mode: {0}", (Object[])new Object[]{I18n.tr((String)"Edit relation", (Object[])new Object[0])}), (int)72, (int)5003), mapFrame, Cursor.getPredefinedCursor(0));
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
    }

    public void mouseMoved(MouseEvent e) {
        Way nearestWay = Main.map.mapView.getNearestWay(e.getPoint(), OsmPrimitive.isUsablePredicate);
        if (nearestWay != this.highlightedWay) {
            if (this.highlightedWay != null) {
                this.highlightedWay.setHighlighted(false);
            }
            if (nearestWay != null) {
                nearestWay.setHighlighted(true);
            }
            this.highlightedWay = nearestWay;
            Main.map.mapView.repaint();
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (Main.main.getCurrentDataSet() == null) {
            return;
        }
        Way way = Main.map.mapView.getNearestWay(e.getPoint(), OsmPrimitive.isUsablePredicate);
        Collection selectedRelations = Main.main.getCurrentDataSet().getSelectedRelations();
        if (way != null) {
            if (selectedRelations.isEmpty()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No relation is selected", (Object[])new Object[0]));
            }
            for (OsmPrimitive rel : selectedRelations) {
                Relation r = (Relation)rel;
                RelationMember foundMember = null;
                for (RelationMember member : r.getMembers()) {
                    if (member.getMember() != way) continue;
                    foundMember = member;
                    break;
                }
                if (foundMember != null) {
                    Main.main.undoRedo.add((Command)new RemoveRelationMemberCommand(r, new RelationMember("", (OsmPrimitive)way)));
                    continue;
                }
                Relation newRelation = new Relation(r);
                newRelation.addMember(new RelationMember("", (OsmPrimitive)way));
                Main.main.undoRedo.add((Command)new ChangeCommand((OsmPrimitive)r, (OsmPrimitive)newRelation));
            }
        }
    }
}

