/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.directdownload;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.plugins.directdownload.UserTrack;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DownloadDataGui
extends ExtendedDialog {
    private NamedResultTableModel model;
    private NamedResultTableColumnModel columnmodel;
    private JTable tblSearchResults;

    public DownloadDataGui() {
        super(Main.parent, I18n.tr((String)"Download Track", (Object[])new Object[0]), new String[]{I18n.tr((String)"Download Track", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])}, true);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        this.model = new NamedResultTableModel(selectionModel);
        this.columnmodel = new NamedResultTableColumnModel();
        this.tblSearchResults = new JTable(this.model, this.columnmodel);
        this.tblSearchResults.setSelectionModel(selectionModel);
        this.tblSearchResults.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane(this.tblSearchResults);
        scrollPane.setPreferredSize(new Dimension(800, 300));
        panel.add((Component)scrollPane, "Center");
        this.model.setData(this.getTrackList());
        this.setContent(panel);
        this.setupDialog();
    }

    private List<UserTrack> getTrackList() {
        String urlString = OsmApi.getOsmApi().getBaseUrl() + "user/gpx_files";
        try {
            URL userTracksUrl = new URL(urlString);
            SAXParserFactory spf = SAXParserFactory.newInstance();
            TrackListHandler handler = new TrackListHandler();
            SAXParser sp = spf.newSAXParser();
            sp.parse(userTracksUrl.openStream(), (DefaultHandler)handler);
            return handler.getResult();
        }
        catch (MalformedURLException e) {
            Main.error((Throwable)e);
            JOptionPane.showMessageDialog(null, I18n.tr((String)"Invalid URL {0}", (Object[])new Object[]{urlString}));
        }
        catch (IOException e) {
            Main.error((Throwable)e);
            JOptionPane.showMessageDialog(null, I18n.tr((String)"Error fetching URL {0}", (Object[])new Object[]{urlString}));
        }
        catch (SAXException e) {
            Main.error((Throwable)e);
            JOptionPane.showMessageDialog(null, I18n.tr((String)"Error parsing data from URL {0}", (Object[])new Object[]{urlString}));
        }
        catch (ParserConfigurationException e) {
            Main.error((Throwable)e);
            JOptionPane.showMessageDialog(null, I18n.tr((String)"Error parsing data from URL {0}", (Object[])new Object[]{urlString}));
        }
        return new LinkedList<UserTrack>();
    }

    public UserTrack getSelectedUserTrack() {
        return this.model.getSelectedUserTrack();
    }

    static class NamedResultCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public NamedResultCellRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }

        protected void reset() {
            this.setText("");
            this.setIcon(null);
        }

        protected void renderColor(boolean selected) {
            if (selected) {
                this.setForeground(UIManager.getColor("Table.selectionForeground"));
                this.setBackground(UIManager.getColor("Table.selectionBackground"));
            } else {
                this.setForeground(UIManager.getColor("Table.foreground"));
                this.setBackground(UIManager.getColor("Table.background"));
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.reset();
            this.renderColor(isSelected);
            if (value == null) {
                return this;
            }
            UserTrack sr = (UserTrack)value;
            switch (column) {
                case 0: {
                    this.setText(sr.datetime);
                    break;
                }
                case 1: {
                    this.setText(sr.filename);
                    break;
                }
                case 2: {
                    this.setText(sr.description);
                }
            }
            return this;
        }
    }

    class ListSelectionHandler
    implements ListSelectionListener {
        ListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent lse) {
        }
    }

    static class NamedResultTableColumnModel
    extends DefaultTableColumnModel {
        protected void createColumns() {
            TableColumn col = null;
            NamedResultCellRenderer renderer = new NamedResultCellRenderer();
            col = new TableColumn(0);
            col.setHeaderValue(I18n.tr((String)"Date", (Object[])new Object[0]));
            col.setResizable(true);
            col.setPreferredWidth(150);
            col.setCellRenderer(renderer);
            this.addColumn(col);
            col = new TableColumn(1);
            col.setHeaderValue(I18n.tr((String)"Filename", (Object[])new Object[0]));
            col.setResizable(true);
            col.setPreferredWidth(200);
            col.setCellRenderer(renderer);
            this.addColumn(col);
            col = new TableColumn(2);
            col.setHeaderValue(I18n.tr((String)"Description", (Object[])new Object[0]));
            col.setResizable(true);
            col.setPreferredWidth(450);
            col.setCellRenderer(renderer);
            this.addColumn(col);
        }

        public NamedResultTableColumnModel() {
            this.createColumns();
        }
    }

    static class NamedResultTableModel
    extends DefaultTableModel {
        private ArrayList<UserTrack> data = new ArrayList();
        private ListSelectionModel selectionModel;

        public NamedResultTableModel(ListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
        }

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (this.data == null) {
                return null;
            }
            return this.data.get(row);
        }

        public void setData(List<UserTrack> data) {
            if (data == null) {
                this.data.clear();
            } else {
                this.data = new ArrayList<UserTrack>(data);
            }
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public UserTrack getSelectedUserTrack() {
            if (this.selectionModel.getMinSelectionIndex() < 0) {
                return null;
            }
            return this.data.get(this.selectionModel.getMinSelectionIndex());
        }
    }

    private static class TrackListHandler
    extends DefaultHandler {
        private LinkedList<UserTrack> data = new LinkedList();
        private String cdata = new String();

        private TrackListHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (qName.equals("gpx_file")) {
                UserTrack track = new UserTrack();
                track.id = atts.getValue("id");
                track.filename = atts.getValue("name");
                track.datetime = atts.getValue("timestamp").replaceAll("[TZ]", " ");
                this.data.addFirst(track);
            }
            this.cdata = new String();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.cdata = this.cdata + new String(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("description")) {
                this.data.getFirst().description = this.cdata;
            }
        }

        public List<UserTrack> getResult() {
            return this.data;
        }
    }
}

