/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress;

import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.czechaddress.DatabaseLoadException;
import org.openstreetmap.josm.plugins.czechaddress.Preferences;
import org.openstreetmap.josm.plugins.czechaddress.StatusListener;
import org.openstreetmap.josm.plugins.czechaddress.actions.ConflictResolveAction;
import org.openstreetmap.josm.plugins.czechaddress.actions.FactoryAction;
import org.openstreetmap.josm.plugins.czechaddress.actions.GroupManipulatorAction;
import org.openstreetmap.josm.plugins.czechaddress.actions.HelpAction;
import org.openstreetmap.josm.plugins.czechaddress.actions.ManagerAction;
import org.openstreetmap.josm.plugins.czechaddress.actions.PointManipulatorAction;
import org.openstreetmap.josm.plugins.czechaddress.actions.SplitAreaByEmptyWayAction;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Database;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.ElementWithStreets;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.House;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Street;
import org.openstreetmap.josm.plugins.czechaddress.gui.ConflictResolver;
import org.openstreetmap.josm.plugins.czechaddress.gui.FactoryDialog;
import org.openstreetmap.josm.plugins.czechaddress.gui.LocationSelector;
import org.openstreetmap.josm.plugins.czechaddress.gui.ManagerDialog;
import org.openstreetmap.josm.plugins.czechaddress.intelligence.Reasoner;
import org.openstreetmap.josm.plugins.czechaddress.intelligence.SelectionMonitor;
import org.openstreetmap.josm.plugins.czechaddress.parser.MvcrParser;
import org.openstreetmap.josm.tools.I18n;

public class CzechAddressPlugin
extends Plugin
implements StatusListener {
    private JMenu czechMenu;
    private List<JMenuItem> menuItems = new ArrayList<JMenuItem>();
    private static Logger logger = Logger.getLogger(CzechAddressPlugin.class.getName());
    private static ElementWithStreets location = null;
    private static final Set<StatusListener> listeners = new HashSet<StatusListener>();

    public void initLoggers() {
        String filename = this.getPluginDir() + "-log.xml";
        try {
            FileHandler fileHandler = new FileHandler(filename);
            fileHandler.setLevel(Level.ALL);
            Enumeration<String> e = LogManager.getLogManager().getLoggerNames();
            while (e.hasMoreElements()) {
                String name = e.nextElement();
                if (!name.startsWith(CzechAddressPlugin.class.getPackage().getName())) continue;
                Logger.getLogger(name).setLevel(Level.FINE);
                Logger.getLogger(name).addHandler(fileHandler);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "cannot create file", ex);
        }
        catch (SecurityException ex) {
            logger.log(Level.SEVERE, "permission denied", ex);
        }
    }

    public CzechAddressPlugin(PluginInformation info) {
        super(info);
        CzechAddressPlugin.addStatusListener(this);
        if (!GraphicsEnvironment.isHeadless()) {
            ConflictResolver.getInstance();
        }
        SelectionMonitor.getInstance();
        Reasoner.getInstance();
        boolean assertionsEnabled = true;
        if (assertionsEnabled) {
            this.initLoggers();
        }
        MainMenu.add((JMenu)Main.main.menu.moreToolsMenu, (JosmAction)new SplitAreaByEmptyWayAction());
        final MvcrParser parser = new MvcrParser();
        parser.setTargetDatabase(Database.getInstance());
        parser.setStorageDir(this.getPluginDir());
        Thread t = new Thread("CzechAddress: DB preload"){

            @Override
            public void run() {
                super.run();
                try {
                    parser.fillDatabase();
                    CzechAddressPlugin.broadcastStatusChange(2);
                }
                catch (DatabaseLoadException dle) {
                    dle.printStackTrace();
                    System.err.println("CzechAddress: Selhalo na\u010dten\u00ed datab\u00e1ze. Plugin je neaktivn\u00ed.");
                }
            }
        };
        t.setPriority(1);
        t.start();
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame == null) {
            return;
        }
        newFrame.addToggleDialog((ToggleDialog)FactoryDialog.getInstance());
        newFrame.addMapMode(new IconToggleButton((Action)((Object)new FactoryAction(newFrame))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initReasoner() {
        Reasoner reasoner;
        Reasoner reasoner2 = reasoner = Reasoner.getInstance();
        synchronized (reasoner2) {
            reasoner.reset();
            reasoner.openTransaction();
            for (House house : location.getAllHouses()) {
                reasoner.update(house);
            }
            for (Street street : location.getAllStreets()) {
                reasoner.update(street);
            }
            DataSet dataSet = Main.main.getCurrentDataSet();
            if (dataSet != null) {
                for (OsmPrimitive prim : dataSet.allPrimitives()) {
                    if (!House.isMatchable(prim) && !Street.isMatchable(prim)) continue;
                    reasoner.update(prim);
                }
            }
            reasoner.closeTransaction();
        }
        ManagerDialog dialog = new ManagerDialog();
        if (dialog.countAutomaticRenameProposals() > 0) {
            dialog.showDialog();
        }
    }

    public static ElementWithStreets getLocation() {
        if (location == null) {
            CzechAddressPlugin.changeLocation();
        }
        return location;
    }

    public static void changeLocation() {
        ElementWithStreets newLocation = LocationSelector.selectLocation();
        if (newLocation != null && newLocation != location) {
            location = newLocation;
            CzechAddressPlugin.broadcastStatusChange(1);
        }
    }

    public static synchronized void addStatusListener(StatusListener l) {
        listeners.add(l);
    }

    public static synchronized void removeStatusListener(StatusListener l) {
        listeners.remove(l);
    }

    public static synchronized void broadcastStatusChange(int statusMessage) {
        for (StatusListener listener : listeners) {
            listener.pluginStatusChanged(statusMessage);
        }
    }

    @Override
    public void pluginStatusChanged(int message) {
        if (message == 2) {
            GuiHelper.runInEDTAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    CzechAddressPlugin.this.czechMenu = Main.main.menu.addMenu("Address", I18n.tr((String)"Address", (Object[])new Object[0]), 90, Main.main.menu.getDefaultMenuPos(), HelpUtil.ht((String)"/Plugin/CzechAddress"));
                    CzechAddressPlugin.this.menuItems.add(MainMenu.add((JMenu)CzechAddressPlugin.this.czechMenu, (JosmAction)new PointManipulatorAction()));
                    CzechAddressPlugin.this.menuItems.add(MainMenu.add((JMenu)CzechAddressPlugin.this.czechMenu, (JosmAction)new GroupManipulatorAction()));
                    CzechAddressPlugin.this.menuItems.add(MainMenu.add((JMenu)CzechAddressPlugin.this.czechMenu, (JosmAction)new ConflictResolveAction()));
                    CzechAddressPlugin.this.menuItems.add(MainMenu.add((JMenu)CzechAddressPlugin.this.czechMenu, (JosmAction)new ManagerAction()));
                    CzechAddressPlugin.this.menuItems.add(MainMenu.add((JMenu)CzechAddressPlugin.this.czechMenu, (JosmAction)new HelpAction()));
                }
            });
            return;
        }
        if (message == 1) {
            CzechAddressPlugin.initReasoner();
            return;
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return Preferences.getInstance();
    }
}

