/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.util.Objects;
import org.apache.logging.log4j.core.util.DummyNanoClock;
import org.apache.logging.log4j.core.util.NanoClock;
import org.apache.logging.log4j.core.util.SystemNanoClock;

public final class NanoClockFactory {
    private static volatile Mode mode = Mode.Dummy;

    private NanoClockFactory() {
    }

    public static NanoClock createNanoClock() {
        return mode.createNanoClock();
    }

    public static Mode getMode() {
        return mode;
    }

    public static void setMode(Mode mode) {
        NanoClockFactory.mode = Objects.requireNonNull(mode, "mode must be non-null");
    }

    public static enum Mode {
        Dummy{

            @Override
            public NanoClock createNanoClock() {
                return new DummyNanoClock();
            }
        }
        ,
        System{

            @Override
            public NanoClock createNanoClock() {
                return new SystemNanoClock();
            }
        };


        public abstract NanoClock createNanoClock();
    }
}

