/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.features;

import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.openstreetmap.josm.plugins.container.OSMWay;

public class OSMClassification {
    private int directClassID = 0;

    public void calculateClasses(OSMWay wayNode, Map<String, String> mappings, Map<String, Integer> mappingsWithIDs, Map<String, List<String>> indirectClasses, Map<String, Integer> indirectClassesIDs) {
        TreeSet<Integer> sortedIndirectIDs = new TreeSet<Integer>();
        TreeSet<Integer> sortedDirectIDs = new TreeSet<Integer>();
        for (Map.Entry<String, String> wayTagKeyValue : wayNode.getTagKeyValue().entrySet()) {
            String key = wayTagKeyValue.getKey() + " " + wayTagKeyValue.getValue();
            for (Map.Entry<String, String> tagMappedToClass : mappings.entrySet()) {
                if (!key.equals(tagMappedToClass.getKey())) continue;
                String className = tagMappedToClass.getValue();
                this.directClassID = mappingsWithIDs.get(className);
                sortedDirectIDs.add(this.directClassID);
                List<String> superClassesList = indirectClasses.get(className);
                if (superClassesList == null) continue;
                for (String superClass : superClassesList) {
                    Integer indirectID = indirectClassesIDs.get(superClass);
                    if (indirectID == null || sortedIndirectIDs.contains(indirectID)) continue;
                    sortedIndirectIDs.add(indirectID);
                }
            }
        }
        wayNode.setClassIDs(sortedDirectIDs);
        wayNode.setClassID(this.directClassID);
    }
}

