/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.plugin.routing.gui;

import com.innovant.josm.jrt.osm.OsmWayTypes;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class RoutingPreferenceDialog
extends DefaultTabPreferenceSetting {
    static Logger logger = Logger.getLogger(RoutingPreferenceDialog.class);
    private Map<String, String> orig;
    private DefaultTableModel model;

    public RoutingPreferenceDialog() {
        super("routing", I18n.tr((String)"Routing Plugin Preferences", (Object[])new Object[0]), I18n.tr((String)"Configure routing preferences.", (Object[])new Object[0]));
        this.readPreferences();
    }

    public void addGui(final PreferenceTabbedPane gui) {
        PreferenceTabbedPane.PreferencePanel principal = gui.createPreferenceTab((TabPreferenceSetting)this);
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        this.model = new DefaultTableModel(new String[]{I18n.tr((String)"Highway type", (Object[])new Object[0]), I18n.tr((String)"Speed (Km/h)", (Object[])new Object[0])}, 0){
            private static final long serialVersionUID = 4253339034781567453L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 0;
            }
        };
        final JTable list = new JTable(this.model);
        this.loadSpeeds(this.model);
        JScrollPane scroll = new JScrollPane(list);
        p.add((Component)scroll, GBC.eol().fill(1));
        scroll.setPreferredSize(new Dimension(200, 200));
        JButton add = new JButton(I18n.tr((String)"Add", (Object[])new Object[0]));
        p.add(Box.createHorizontalGlue(), GBC.std().fill(2));
        p.add((Component)add, GBC.std().insets(0, 5, 0, 0));
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPanel p = new JPanel(new GridBagLayout());
                p.add((Component)new JLabel(I18n.tr((String)"Weight", (Object[])new Object[0])), GBC.std().insets(0, 0, 5, 0));
                JComboBox<String> key = new JComboBox<String>();
                for (OsmWayTypes pk : OsmWayTypes.values()) {
                    key.addItem(pk.getTag());
                }
                JTextField value = new JTextField(10);
                p.add(key, GBC.eop().insets(5, 0, 0, 0).fill(2));
                p.add((Component)new JLabel(I18n.tr((String)"Value", (Object[])new Object[0])), GBC.std().insets(0, 0, 5, 0));
                p.add((Component)value, GBC.eol().insets(5, 0, 0, 0).fill(2));
                int answer = JOptionPane.showConfirmDialog((Component)gui, p, I18n.tr((String)"Enter weight values", (Object[])new Object[0]), 2);
                if (answer == 0) {
                    RoutingPreferenceDialog.this.model.addRow(new String[]{key.getSelectedItem().toString(), value.getText()});
                }
            }
        });
        JButton delete = new JButton(I18n.tr((String)"Delete", (Object[])new Object[0]));
        p.add((Component)delete, GBC.std().insets(0, 5, 0, 0));
        delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (list.getSelectedRow() == -1) {
                    JOptionPane.showMessageDialog((Component)gui, I18n.tr((String)"Please select the row to delete.", (Object[])new Object[0]));
                } else {
                    Integer i;
                    while ((i = Integer.valueOf(list.getSelectedRow())) != -1) {
                        RoutingPreferenceDialog.this.model.removeRow(i);
                    }
                }
            }
        });
        JButton edit = new JButton(I18n.tr((String)"Edit", (Object[])new Object[0]));
        p.add((Component)edit, GBC.std().insets(5, 5, 5, 0));
        edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RoutingPreferenceDialog.this.edit(gui, list);
            }
        });
        JTabbedPane Opciones = new JTabbedPane();
        Opciones.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        Opciones.addTab("Profile", null, p, null);
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    RoutingPreferenceDialog.this.edit(gui, list);
                }
            }
        });
        principal.add((Component)Opciones, GBC.eol().fill(1));
    }

    public boolean ok() {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            String value = this.model.getValueAt(i, 1).toString();
            if (value.length() == 0) continue;
            String key = this.model.getValueAt(i, 0).toString();
            String origValue = this.orig.get(key);
            if (origValue == null || !origValue.equals(value)) {
                Main.pref.put(key, value);
            }
            this.orig.remove(key);
        }
        for (Map.Entry<String, String> e : this.orig.entrySet()) {
            Main.pref.put(e.getKey(), null);
        }
        return false;
    }

    private void edit(PreferenceTabbedPane gui, JTable list) {
        if (list.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog((Component)gui, I18n.tr((String)"Please select the row to edit.", (Object[])new Object[0]));
            return;
        }
        String v = JOptionPane.showInputDialog(I18n.tr((String)"New value for {0}", (Object[])new Object[]{this.model.getValueAt(list.getSelectedRow(), 0)}), this.model.getValueAt(list.getSelectedRow(), 1));
        if (v != null) {
            this.model.setValueAt(v, list.getSelectedRow(), 1);
        }
    }

    private void loadSpeeds(DefaultTableModel model) {
        this.readPreferences();
        for (String tag : this.orig.keySet()) {
            model.addRow(new String[]{tag, this.orig.get(tag)});
        }
    }

    private void readPreferences() {
        this.orig = Main.pref.getAllPrefix("routing.profile.default.speed");
        if (this.orig.size() == 0) {
            logger.debug((Object)"Loading Default Preferences.");
            for (OsmWayTypes owt : OsmWayTypes.values()) {
                Main.pref.putInteger("routing.profile.default.speed." + owt.getTag(), Integer.valueOf(owt.getSpeed()));
            }
            this.orig = Main.pref.getAllPrefix("routing.profile.default.speed");
        } else {
            logger.debug((Object)"Default preferences already exist.");
        }
    }
}

