/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.utils;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.GpsTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImportedImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillarySequence;
import org.openstreetmap.josm.plugins.mapillary.utils.PluginState;
import org.openstreetmap.josm.tools.I18n;

public final class MapillaryUtils {
    private static final double MIN_ZOOM_SQUARE_SIDE = 0.002;

    private MapillaryUtils() {
    }

    public static void browse(URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException();
        }
        Desktop desktop = Desktop.getDesktop();
        if (desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(url.toURI());
            }
            catch (URISyntaxException e1) {
                throw new IOException(e1);
            }
        } else {
            Runtime runtime = Runtime.getRuntime();
            runtime.exec("xdg-open " + url);
        }
    }

    public static String currentDate() {
        return new SimpleDateFormat("yyyy:MM:dd HH:mm:ss", Locale.UK).format(Calendar.getInstance().getTime());
    }

    public static long currentTime() {
        return Calendar.getInstance().getTimeInMillis();
    }

    public static long getEpoch(String date, String format) throws ParseException {
        return new SimpleDateFormat(format, Locale.UK).parse(date).getTime();
    }

    public static double degMinSecToDouble(RationalNumber[] degMinSec, String ref) {
        if (degMinSec == null || degMinSec.length != 3) {
            throw new IllegalArgumentException("Array's length must be 3.");
        }
        for (int i = 0; i < 3; ++i) {
            if (degMinSec[i] != null) continue;
            throw new IllegalArgumentException("Null value in array.");
        }
        switch (ref) {
            case "N": 
            case "S": 
            case "E": 
            case "W": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid ref.");
            }
        }
        double result = degMinSec[0].doubleValue();
        result += degMinSec[1].doubleValue() / 60.0;
        result += degMinSec[2].doubleValue() / 3600.0;
        if ("S".equals(ref) || "W".equals(ref)) {
            result *= -1.0;
        }
        result = 360.0 * ((result + 180.0) / 360.0 - Math.floor((result + 180.0) / 360.0)) - 180.0;
        return result;
    }

    public static String getExtension(File file) {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("The file is a directory");
        }
        int k = file.getName().lastIndexOf(46);
        if (k > 0) {
            return file.getName().substring(k + 1).toLowerCase();
        }
        throw new IllegalArgumentException("Error parsing the extension");
    }

    public static synchronized void join(MapillaryAbstractImage mapillaryAbstractImage, MapillaryAbstractImage mapillaryAbstractImage2) {
        MapillarySequence seq;
        MapillaryAbstractImage firstImage = mapillaryAbstractImage;
        MapillaryAbstractImage secondImage = mapillaryAbstractImage2;
        if (mapillaryAbstractImage.next() != null) {
            firstImage = mapillaryAbstractImage2;
            secondImage = mapillaryAbstractImage;
        }
        if (firstImage.getSequence() == null) {
            seq = new MapillarySequence();
            seq.add(firstImage);
            firstImage.setSequence(seq);
        }
        if (secondImage.getSequence() == null) {
            seq = new MapillarySequence();
            seq.add(secondImage);
            mapillaryAbstractImage2.setSequence(seq);
        }
        for (MapillaryAbstractImage img : secondImage.getSequence().getImages()) {
            firstImage.getSequence().add(img);
            img.setSequence(firstImage.getSequence());
        }
        if (Main.main != null) {
            MapillaryData.dataUpdated();
        }
    }

    public static MapillaryImportedImage readJPG(File file) throws IOException, ImageReadException {
        return MapillaryUtils.readJPG(file, false);
    }

    public static MapillaryImportedImage readJPG(File file, boolean exceptionNoTags) throws IOException, ImageReadException {
        ImageMetadata metadata = Imaging.getMetadata((File)file);
        if (metadata instanceof JpegImageMetadata) {
            JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
            TiffField lat_ref = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)GpsTagConstants.GPS_TAG_GPS_LATITUDE_REF);
            TiffField lat = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)GpsTagConstants.GPS_TAG_GPS_LATITUDE);
            TiffField lon_ref = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)GpsTagConstants.GPS_TAG_GPS_LONGITUDE_REF);
            TiffField lon = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)GpsTagConstants.GPS_TAG_GPS_LONGITUDE);
            TiffField ca = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION);
            TiffField datetimeOriginal = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL);
            if (lat_ref == null || lat == null || lon == null || lon_ref == null) {
                if (exceptionNoTags) {
                    throw new IllegalArgumentException("The image doesn't have the needed EXIF tags.");
                }
                return MapillaryUtils.readNoTags(file);
            }
            double latValue = 0.0;
            double lonValue = 0.0;
            double caValue = 0.0;
            if (lat.getValue() instanceof RationalNumber[]) {
                latValue = MapillaryUtils.degMinSecToDouble((RationalNumber[])lat.getValue(), lat_ref.getValue().toString());
            }
            if (lon.getValue() instanceof RationalNumber[]) {
                lonValue = MapillaryUtils.degMinSecToDouble((RationalNumber[])lon.getValue(), lon_ref.getValue().toString());
            }
            if (ca != null && ca.getValue() instanceof RationalNumber) {
                caValue = ((RationalNumber)ca.getValue()).doubleValue();
            }
            if (datetimeOriginal != null) {
                return new MapillaryImportedImage(latValue, lonValue, caValue, file, datetimeOriginal.getStringValue());
            }
            return new MapillaryImportedImage(latValue, lonValue, caValue, file);
        }
        throw new IllegalStateException("Invalid format.");
    }

    public static MapillaryImportedImage readNoTags(File file) {
        return MapillaryUtils.readNoTags(file, Main.map.mapView.getProjection().eastNorth2latlon(Main.map.mapView.getCenter()));
    }

    public static MapillaryImportedImage readNoTags(File file, LatLon pos) {
        ImageMetadata metadata = null;
        try {
            metadata = Imaging.getMetadata((File)file);
        }
        catch (IOException e) {
            Main.error((Throwable)e);
        }
        catch (ImageReadException e) {
            Main.error((Throwable)e);
        }
        if (metadata instanceof JpegImageMetadata) {
            JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
            TiffField datetimeOriginal = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL);
            if (datetimeOriginal == null) {
                return new MapillaryImportedImage(pos.lat(), pos.lon(), 0.0, file);
            }
            try {
                return new MapillaryImportedImage(pos.lat(), pos.lon(), 0.0, file, datetimeOriginal.getStringValue());
            }
            catch (ImageReadException e) {
                Main.error((Throwable)e);
            }
        }
        return new MapillaryImportedImage(pos.lat(), pos.lon(), 0.0, file);
    }

    public static MapillaryImportedImage readPNG(File file) {
        return MapillaryUtils.readNoTags(file);
    }

    public static void showAllPictures() {
        MapillaryUtils.showPictures(MapillaryLayer.getInstance().getData().getImages(), false);
    }

    public static void showPictures(final Set<MapillaryAbstractImage> images, final boolean select) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapillaryUtils.showPictures(images, select);
                }
            });
        } else {
            Bounds zoomBounds = null;
            if (images.isEmpty()) {
                zoomBounds = new Bounds(new LatLon(0.0, 0.0));
            } else {
                for (MapillaryAbstractImage img : images) {
                    if (zoomBounds == null) {
                        zoomBounds = new Bounds(img.getLatLon());
                        continue;
                    }
                    zoomBounds.extend(img.getLatLon());
                }
            }
            double latExtent = Math.max(zoomBounds.getMaxLat() - zoomBounds.getMinLat(), 0.002);
            double lonExtent = Math.max(zoomBounds.getMaxLon() - zoomBounds.getMinLon(), 0.002);
            zoomBounds = new Bounds(zoomBounds.getCenter(), latExtent, lonExtent);
            Main.map.mapView.zoomTo(zoomBounds);
            MapillaryLayer.getInstance().getData().setSelectedImage(null);
            if (select) {
                MapillaryLayer.getInstance().getData().addMultiSelectedImage(images);
            }
            if (Main.main != null) {
                MapillaryData.dataUpdated();
            }
        }
    }

    public static synchronized void unjoin(MapillaryAbstractImage mapillaryAbstractImage, MapillaryAbstractImage mapillaryAbstractImage2) {
        MapillaryAbstractImage firstImage = mapillaryAbstractImage;
        MapillaryAbstractImage secondImage = mapillaryAbstractImage2;
        if (mapillaryAbstractImage.next() != mapillaryAbstractImage2) {
            firstImage = mapillaryAbstractImage2;
            secondImage = mapillaryAbstractImage;
        }
        ArrayList<MapillaryAbstractImage> firstHalf = new ArrayList<MapillaryAbstractImage>(firstImage.getSequence().getImages().subList(0, firstImage.getSequence().getImages().indexOf(secondImage)));
        ArrayList<MapillaryAbstractImage> secondHalf = new ArrayList<MapillaryAbstractImage>(firstImage.getSequence().getImages().subList(firstImage.getSequence().getImages().indexOf(secondImage), firstImage.getSequence().getImages().size()));
        MapillarySequence seq1 = new MapillarySequence();
        MapillarySequence seq2 = new MapillarySequence();
        for (MapillaryAbstractImage img : firstHalf) {
            img.setSequence(seq1);
            seq1.add(img);
        }
        for (MapillaryAbstractImage img : secondHalf) {
            img.setSequence(seq2);
            seq2.add(img);
        }
        if (Main.main != null) {
            MapillaryData.dataUpdated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateHelpText() {
        StringBuilder ret = new StringBuilder();
        if (PluginState.isDownloading()) {
            ret.append(I18n.tr((String)"Downloading Mapillary images", (Object[])new Object[0]));
        } else if (MapillaryLayer.getInstance().getData().size() > 0) {
            ret.append(I18n.tr((String)"Total Mapillary images: {0}", (Object[])new Object[]{MapillaryLayer.getInstance().getData().size()}));
        } else {
            ret.append(I18n.tr((String)"No images found", (Object[])new Object[0]));
        }
        if (MapillaryLayer.getInstance().mode != null) {
            ret.append(" \u2014 ").append(I18n.tr((String)MapillaryLayer.getInstance().mode.toString(), (Object[])new Object[0]));
        }
        if (PluginState.isUploading()) {
            ret.append(" \u2014 ").append(PluginState.getUploadString());
        }
        Class<MapillaryUtils> clazz = MapillaryUtils.class;
        synchronized (MapillaryUtils.class) {
            Main.map.statusLine.setHelpText(ret.toString());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

