/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.history;

import java.util.ArrayList;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.history.MapillaryRecordListener;
import org.openstreetmap.josm.plugins.mapillary.history.commands.MapillaryCommand;
import org.openstreetmap.josm.plugins.mapillary.history.commands.MapillaryExecutableCommand;

public class MapillaryRecord {
    private static MapillaryRecord instance;
    private final ArrayList<MapillaryRecordListener> listeners = new ArrayList();
    public ArrayList<MapillaryCommand> commandList = new ArrayList();
    public int position = -1;

    public static synchronized MapillaryRecord getInstance() {
        if (instance == null) {
            instance = new MapillaryRecord();
        }
        return instance;
    }

    public void addListener(MapillaryRecordListener lis) {
        this.listeners.add(lis);
    }

    public void removeListener(MapillaryRecordListener lis) {
        this.listeners.remove(lis);
    }

    public void addCommand(MapillaryCommand command) {
        if (command instanceof MapillaryExecutableCommand) {
            ((MapillaryExecutableCommand)command).execute();
        }
        if (this.position != -1) {
            boolean equalSets = true;
            for (MapillaryAbstractImage img : this.commandList.get((int)this.position).images) {
                if (command.images.contains(img)) continue;
                equalSets = false;
            }
            for (MapillaryAbstractImage img : command.images) {
                if (this.commandList.get((int)this.position).images.contains(img)) continue;
                equalSets = false;
            }
            if (equalSets && this.commandList.get(this.position).getClass() == command.getClass()) {
                this.commandList.get(this.position).sum(command);
                this.fireRecordChanged();
                return;
            }
        }
        this.commandList.add(this.position + 1, command);
        ++this.position;
        while (this.commandList.size() > this.position + 1) {
            this.commandList.remove(this.position + 1);
        }
        this.fireRecordChanged();
    }

    public void undo() {
        if (this.position == -1) {
            throw new IllegalStateException();
        }
        this.commandList.get(this.position).undo();
        --this.position;
        this.fireRecordChanged();
    }

    public void redo() {
        if (this.position + 1 >= this.commandList.size()) {
            throw new IllegalStateException();
        }
        ++this.position;
        this.commandList.get(this.position).redo();
        this.fireRecordChanged();
    }

    private void fireRecordChanged() {
        for (MapillaryRecordListener lis : this.listeners) {
            if (lis == null) continue;
            lis.recordChanged();
        }
    }

    public void reset() {
        this.commandList.clear();
        this.position = -1;
    }
}

