/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.io.download.MapillaryDownloader;
import org.openstreetmap.josm.plugins.mapillary.oauth.MapillaryLoginListener;
import org.openstreetmap.josm.plugins.mapillary.oauth.MapillaryUser;
import org.openstreetmap.josm.plugins.mapillary.oauth.OAuthPortListener;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryURL;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryUtils;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class MapillaryPreferenceSetting
implements SubPreferenceSetting,
MapillaryLoginListener {
    private final JCheckBox reverseButtons = new JCheckBox(I18n.tr((String)"Reverse buttons position when displaying images.", (Object[])new Object[0]));
    private final JComboBox<String> downloadMode = new JComboBox<String>(new String[]{MapillaryDownloader.MODES.Automatic.toString(), MapillaryDownloader.MODES.Semiautomatic.toString(), MapillaryDownloader.MODES.Manual.toString()});
    private final JCheckBox displayHour = new JCheckBox(I18n.tr((String)"Display hour when the picture was taken", (Object[])new Object[0]));
    private final JCheckBox format24 = new JCheckBox(I18n.tr((String)"Use 24 hour format", (Object[])new Object[0]));
    private final JCheckBox moveTo = new JCheckBox(I18n.tr((String)"Move to picture''s location with next/previous buttons", (Object[])new Object[0]));
    private final JButton loginButton = new JButton(new LoginAction(this));
    private final JButton logoutButton = new JButton(new LogoutAction());
    private final JLabel loginLabel = new JLabel();
    private final JPanel loginPanel = new JPanel();

    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane gui) {
        return gui.getDisplayPreference();
    }

    public void addGui(PreferenceTabbedPane gui) {
        JPanel panel = new JPanel();
        this.reverseButtons.setSelected(Main.pref.getBoolean("mapillary.reverse-buttons"));
        this.displayHour.setSelected(Main.pref.getBoolean("mapillary.display-hour", true));
        this.format24.setSelected(Main.pref.getBoolean("mapillary.format-24"));
        this.moveTo.setSelected(Main.pref.getBoolean("mapillary.move-to-picture", true));
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)this.reverseButtons, GBC.eol());
        if (Main.pref.get("mapillary.download-mode").equals(MapillaryDownloader.MODES.Automatic.toString()) || Main.pref.get("mapillary.download-mode").equals(MapillaryDownloader.MODES.Semiautomatic.toString()) || Main.pref.get("mapillary.download-mode").equals(MapillaryDownloader.MODES.Manual.toString())) {
            this.downloadMode.setSelectedItem(Main.pref.get("mapillary.download-mode"));
        }
        JPanel downloadModePanel = new JPanel();
        downloadModePanel.add(new JLabel(I18n.tr((String)"Download mode", (Object[])new Object[0])));
        downloadModePanel.add(this.downloadMode);
        panel.add((Component)downloadModePanel, GBC.eol());
        panel.add((Component)this.displayHour, GBC.eol());
        panel.add((Component)this.format24, GBC.eol());
        panel.add((Component)this.moveTo, GBC.eol());
        this.loginPanel.setLayout(new FlowLayout(3));
        this.loginPanel.add((Component)this.loginButton, 0);
        this.loginPanel.add((Component)this.loginLabel, 1);
        this.onLogout();
        panel.add((Component)this.loginPanel, GBC.eol());
        panel.add(Box.createVerticalGlue(), GBC.eol().fill(1));
        gui.getDisplayPreference().addSubTab((SubPreferenceSetting)this, "Mapillary", (Component)new JScrollPane(panel));
        new Thread(new Runnable(){

            @Override
            public void run() {
                String username = MapillaryUser.getUsername();
                if (username != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MapillaryPreferenceSetting.this.onLogin(MapillaryUser.getUsername());
                        }
                    });
                }
            }
        }).start();
    }

    @Override
    public void onLogin(String username) {
        this.loginPanel.add((Component)this.logoutButton, 1);
        this.loginLabel.setText(I18n.tr((String)"You are logged in as ''{0}''.", (Object[])new Object[]{username}));
        this.loginButton.setText(I18n.tr((String)"Re-Login", (Object[])new Object[0]));
        this.logoutButton.setText(I18n.tr((String)"Logout", (Object[])new Object[0]));
    }

    @Override
    public void onLogout() {
        this.loginPanel.remove(this.logoutButton);
        this.loginLabel.setText(I18n.tr((String)"You are currently not logged in.", (Object[])new Object[0]));
        this.loginButton.setText(I18n.tr((String)"Login", (Object[])new Object[0]));
    }

    public boolean ok() {
        boolean mod = false;
        Main.pref.put("mapillary.reverse-buttons", this.reverseButtons.isSelected());
        MapillaryPlugin.setMenuEnabled(MapillaryPlugin.getDownloadViewMenu(), false);
        if (this.downloadMode.getSelectedItem().equals(MapillaryDownloader.MODES.Automatic.toString())) {
            Main.pref.put("mapillary.download-mode", MapillaryDownloader.MODES.Automatic.toString());
        }
        if (this.downloadMode.getSelectedItem().equals(MapillaryDownloader.MODES.Semiautomatic.toString())) {
            Main.pref.put("mapillary.download-mode", MapillaryDownloader.MODES.Semiautomatic.toString());
        }
        if (this.downloadMode.getSelectedItem().equals(MapillaryDownloader.MODES.Manual.toString())) {
            Main.pref.put("mapillary.download-mode", MapillaryDownloader.MODES.Manual.toString());
            MapillaryPlugin.setMenuEnabled(MapillaryPlugin.getDownloadViewMenu(), true);
        }
        Main.pref.put("mapillary.display-hour", this.displayHour.isSelected());
        Main.pref.put("mapillary.format-24", this.format24.isSelected());
        Main.pref.put("mapillary.move-to-picture", this.moveTo.isSelected());
        return mod;
    }

    public boolean isExpert() {
        return false;
    }

    public class LogoutAction
    extends AbstractAction {
        private static final long serialVersionUID = 3434780936404707219L;

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MapillaryUser.reset();
            Main.pref.put("mapillary.access-token", null);
            MapillaryPreferenceSetting.this.onLogout();
        }
    }

    public class LoginAction
    extends AbstractAction {
        private static final long serialVersionUID = -3908477563072057344L;
        private final transient MapillaryLoginListener callback;

        public LoginAction(MapillaryLoginListener loginCallback) {
            this.callback = loginCallback;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            OAuthPortListener portListener = new OAuthPortListener(this.callback);
            portListener.start();
            try {
                MapillaryUtils.browse(MapillaryURL.connectURL("http://localhost:8763"));
            }
            catch (IOException e) {
                Main.error((Throwable)e);
            }
        }
    }
}

