/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.actions;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryDataListener;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.actions.WalkListener;
import org.openstreetmap.josm.plugins.mapillary.actions.WalkThread;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryMainDialog;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryWalkDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MapillaryWalkAction
extends JosmAction
implements MapillaryDataListener {
    private static final long serialVersionUID = 3454223919402245818L;
    private WalkThread thread = null;
    private final ArrayList<WalkListener> listeners = new ArrayList();

    public MapillaryWalkAction() {
        super(I18n.tr((String)"Walk mode", (Object[])new Object[0]), MapillaryPlugin.getProvider("icon24.png"), I18n.tr((String)"Walk mode", (Object[])new Object[0]), Shortcut.registerShortcut((String)"Mapillary walk", (String)I18n.tr((String)"Start walk mode", (Object[])new Object[0]), (int)65535, (int)5000), false, "mapillaryWalk", false);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent arg0) {
        MapillaryWalkDialog dialog = new MapillaryWalkDialog();
        JOptionPane pane = new JOptionPane(dialog, -1, 2);
        JDialog dlg = pane.createDialog(Main.parent, I18n.tr((String)"Walk mode", (Object[])new Object[0]));
        dlg.setMinimumSize(new Dimension(400, 150));
        dlg.setVisible(true);
        if (pane.getValue() != null && (Integer)pane.getValue() == 0) {
            this.thread = new WalkThread((Integer)dialog.spin.getValue(), dialog.waitForPicture.isSelected(), dialog.followSelection.isSelected(), dialog.goForward.isSelected());
            this.fireWalkStarted();
            this.thread.start();
            MapillaryMainDialog.getInstance().setMode(MapillaryMainDialog.MODE.WALK);
        }
    }

    @Override
    public void imagesAdded() {
    }

    public void addListener(WalkListener lis) {
        this.listeners.add(lis);
    }

    public void removeListener(WalkListener lis) {
        this.listeners.remove(lis);
    }

    private void fireWalkStarted() {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (WalkListener lis : this.listeners) {
            lis.walkStarted(this.thread);
        }
    }

    @Override
    public void selectedImageChanged(MapillaryAbstractImage oldImage, MapillaryAbstractImage newImage) {
        MapillaryPlugin.setMenuEnabled(MapillaryPlugin.getWalkMenu(), newImage != null);
    }
}

