/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.imaging.ImageReadException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.history.MapillaryRecord;
import org.openstreetmap.josm.plugins.mapillary.history.commands.CommandImport;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MapillaryImportAction
extends JosmAction {
    private static final long serialVersionUID = 4995924098228081806L;

    public MapillaryImportAction() {
        super(I18n.tr((String)"Import pictures", (Object[])new Object[0]), MapillaryPlugin.getProvider("icon24.png"), I18n.tr((String)"Import local pictures", (Object[])new Object[0]), Shortcut.registerShortcut((String)"Import Mapillary", (String)I18n.tr((String)"Import pictures into Mapillary layer", (Object[])new Object[0]), (int)65535, (int)5000), false, "mapillaryImport", false);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent event) {
        JFileChooser chooser = new JFileChooser();
        File startDirectory = new File(Main.pref.get("mapillary.start-directory", System.getProperty("user.home")));
        chooser.setCurrentDirectory(startDirectory);
        chooser.setDialogTitle(I18n.tr((String)"Select pictures", (Object[])new Object[0]));
        chooser.setFileSelectionMode(2);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter(new FileNameExtensionFilter("images", "jpg", "jpeg", "png"));
        chooser.setMultiSelectionEnabled(true);
        if (chooser.showOpenDialog(Main.parent) == 0) {
            ConcurrentSkipListSet<MapillaryAbstractImage> images = new ConcurrentSkipListSet<MapillaryAbstractImage>();
            for (File file : chooser.getSelectedFiles()) {
                Main.pref.put("mapillary.start-directory", file.getParent());
                MapillaryLayer.getInstance();
                if (file.isDirectory()) {
                    if (file.listFiles() == null) continue;
                    for (File innerFile : file.listFiles()) {
                        String extension = MapillaryUtils.getExtension(innerFile);
                        try {
                            if ("jpg".equals(extension) || "jpeg".equals(extension)) {
                                images.add(MapillaryUtils.readJPG(innerFile));
                                continue;
                            }
                            if (!"png".equals(extension)) continue;
                            images.add(MapillaryUtils.readPNG(innerFile));
                        }
                        catch (IOException | NullPointerException | ImageReadException e1) {
                            Main.error((Throwable)e1);
                        }
                    }
                    continue;
                }
                String extension = MapillaryUtils.getExtension(file);
                if ("jpg".equals(extension) || "jpeg".equals(extension)) {
                    try {
                        images.add(MapillaryUtils.readJPG(file));
                    }
                    catch (ImageReadException ex) {
                        Main.error((Throwable)ex);
                    }
                    catch (IOException ex) {
                        Main.error((Throwable)ex);
                    }
                    continue;
                }
                if (!".png".equals(file.getPath().substring(file.getPath().length() - 4))) continue;
                images.add(MapillaryUtils.readPNG(file));
            }
            MapillaryRecord.getInstance().addCommand(new CommandImport(images));
            MapillaryUtils.showAllPictures();
        }
    }
}

