/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.discoverer;

import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_discoverer_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_list_t;
import uk.co.caprica.vlcj.medialist.MediaList;
import uk.co.caprica.vlcj.player.NativeString;

public class MediaDiscoverer {
    private final Logger logger = LoggerFactory.getLogger(MediaDiscoverer.class);
    private final LibVlc libvlc;
    private final libvlc_instance_t instance;
    private final String name;
    private libvlc_media_discoverer_t mediaDiscovererInstance;
    private final AtomicBoolean released = new AtomicBoolean();

    public MediaDiscoverer(LibVlc libvlc, libvlc_instance_t instance, String name) {
        this.libvlc = libvlc;
        this.instance = instance;
        this.name = name;
        this.createInstance();
    }

    public final String getName() {
        return this.name;
    }

    public final String getLocalisedName() {
        return NativeString.getNativeString(this.libvlc, this.libvlc.libvlc_media_discoverer_localized_name(this.mediaDiscovererInstance));
    }

    public final MediaList getMediaList() {
        libvlc_media_list_t mediaListInstance = this.libvlc.libvlc_media_discoverer_media_list(this.mediaDiscovererInstance);
        MediaList mediaList = new MediaList(this.libvlc, this.instance, mediaListInstance);
        this.libvlc.libvlc_media_list_release(mediaListInstance);
        return mediaList;
    }

    public final void release() {
        this.logger.debug("release()");
        if (this.released.compareAndSet(false, true)) {
            this.destroyInstance();
        }
    }

    private void createInstance() {
        this.logger.debug("createInstance()");
        this.mediaDiscovererInstance = this.libvlc.libvlc_media_discoverer_new_from_name(this.instance, this.name);
        this.logger.debug("mediaDiscovererInstance={}", (Object)this.mediaDiscovererInstance);
        if (this.mediaDiscovererInstance == null) {
            throw new IllegalArgumentException("No media discoverer for '" + this.name + "' is available on this platform");
        }
    }

    private void destroyInstance() {
        this.logger.debug("destroyInstance()");
        if (this.mediaDiscovererInstance != null) {
            this.logger.debug("Release media discoverer...");
            this.libvlc.libvlc_media_discoverer_release(this.mediaDiscovererInstance);
            this.logger.debug("Media discoverer released.");
        }
    }
}

