/*
 * Decompiled with CFR 0.152.
 */
package nanolog;

import java.awt.Rectangle;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import nanolog.NanoLogEntry;
import nanolog.NanoLogLayer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;

public class NanoLogPanel
extends ToggleDialog
implements MapView.LayerChangeListener,
NanoLogLayer.NanoLogLayerListener {
    private JList<String> logPanel;
    private LogListModel listModel = new LogListModel();

    public NanoLogPanel() {
        super(I18n.tr((String)"NanoLog", (Object[])new Object[0]), "nanolog", I18n.tr((String)"Open NanoLog panel", (Object[])new Object[0]), null, 150, false);
        this.logPanel = new JList<String>(this.listModel);
        this.createLayout(this.logPanel, true, null);
    }

    public void updateMarkers() {
        ArrayList<NanoLogEntry> entries = new ArrayList<NanoLogEntry>();
        for (NanoLogLayer l : Main.map.mapView.getLayersOfType(NanoLogLayer.class)) {
            entries.addAll(l.getEntries());
        }
        this.listModel.setEntries(entries);
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    public void layerAdded(Layer newLayer) {
        if (newLayer instanceof NanoLogLayer) {
            ((NanoLogLayer)newLayer).addListener(this);
        }
        this.updateMarkers();
    }

    public void layerRemoved(Layer oldLayer) {
        this.updateMarkers();
    }

    @Override
    public void markersUpdated(NanoLogLayer layer) {
        this.updateMarkers();
    }

    @Override
    public void markerActivated(NanoLogLayer layer, NanoLogEntry entry) {
        int idx;
        int n = idx = entry == null ? -1 : this.listModel.find(entry);
        if (idx >= 0) {
            this.logPanel.setSelectedIndex(idx);
            Rectangle rect = this.logPanel.getCellBounds(Math.max(0, idx - 2), Math.min(idx + 4, this.listModel.getSize()));
            this.logPanel.scrollRectToVisible(rect);
        }
    }

    private class LogListModel
    extends AbstractListModel<String> {
        private List<NanoLogEntry> entries;
        private final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");

        private LogListModel() {
        }

        @Override
        public int getSize() {
            return this.entries.size();
        }

        @Override
        public String getElementAt(int index) {
            return this.TIME_FORMAT.format(this.entries.get(index).getTime()) + " " + this.entries.get(index).getMessage();
        }

        public void setEntries(List<NanoLogEntry> entries) {
            this.entries = entries;
            this.fireContentsChanged(this, 0, entries.size());
        }

        public int find(NanoLogEntry entry) {
            return this.entries.indexOf(entry);
        }
    }
}

