/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class PasteRelationsAction
extends JosmAction {
    private static final String TITLE = I18n.tr((String)"Paste Relations", (Object[])new Object[0]);

    public PasteRelationsAction() {
        super(TITLE, "dumbutils/pasterelations", I18n.tr((String)"Paste relation membership from objects in the buffer onto selected object(s)", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:pasterelations", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Paste Relations", (Object[])new Object[0])}), (int)86, (int)5008), true);
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = PasteRelationsAction.getCurrentDataSet().getSelected();
        if (selection.isEmpty()) {
            return;
        }
        HashMap<Relation, String> relations = new HashMap<Relation, String>();
        for (PrimitiveData pdata : Main.pasteBuffer.getDirectlyAdded()) {
            OsmPrimitive p = PasteRelationsAction.getCurrentDataSet().getPrimitiveById(pdata.getUniqueId(), pdata.getType());
            if (p == null) continue;
            for (Relation r : OsmPrimitive.getFilteredList((Collection)p.getReferrers(), Relation.class)) {
                String role = (String)relations.get(r);
                for (RelationMember m : r.getMembers()) {
                    if (!m.getMember().equals((Object)p)) continue;
                    String newRole = m.getRole();
                    if (newRole != null && role == null) {
                        role = newRole;
                        continue;
                    }
                    if (!(newRole != null ? !newRole.equals(role) : role != null)) continue;
                    role = "";
                    break;
                }
                relations.put(r, role);
            }
        }
        ArrayList<ChangeCommand> commands = new ArrayList<ChangeCommand>();
        for (Relation rel : relations.keySet()) {
            Relation r = new Relation(rel);
            boolean changed = false;
            for (OsmPrimitive p : selection) {
                if (r.getMemberPrimitives().contains(p) || r.equals((Object)p)) continue;
                String role = (String)relations.get(rel);
                if ("associatedStreet".equals(r.get("type"))) {
                    if (p.get("highway") != null) {
                        role = "street";
                    } else if (p.get("addr:housenumber") != null) {
                        role = "house";
                    }
                }
                r.addMember(new RelationMember(role, p));
                changed = true;
            }
            if (!changed) continue;
            commands.add(new ChangeCommand((OsmPrimitive)rel, (OsmPrimitive)r));
        }
        if (!commands.isEmpty()) {
            Main.main.undoRedo.add((Command)new SequenceCommand(TITLE, commands));
        }
    }

    protected void updateEnabledState() {
        if (PasteRelationsAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(PasteRelationsAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty() && !Main.pasteBuffer.isEmpty());
    }
}

