/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker.commandlineinterface;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import org.openstreetmap.josm.plugins.JunctionChecker.connectedness.StrongConnectednessCalculator;
import org.openstreetmap.josm.plugins.JunctionChecker.converting.ChannelDigraphBuilder;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.Channel;
import org.openstreetmap.josm.plugins.JunctionChecker.filter.ExecuteFilter;
import org.openstreetmap.josm.plugins.JunctionChecker.junctionchecking.JunctionChecker;
import org.openstreetmap.josm.plugins.JunctionChecker.reader.OSMXMLReader;
import org.openstreetmap.josm.plugins.JunctionChecker.reader.XMLFilterReader;
import org.openstreetmap.josm.plugins.JunctionChecker.writing.OSMXMLWriter;

public class CLI {
    public static void main(String[] args) {
        String inputosm = "";
        String outputosm = "";
        int maxchannelsearch = 0;
        int ticks = 0;
        int n = 0;
        int runs = 0;
        String WAYFILTERFILE = "/resources/xml/waysfilter.xml";
        if (args.length != 6) {
            System.out.println("Parameter:\n inputosm (osmxml) \n outputchannelosm (outputosmxml) \n maxchannelsearch (wieviele channel sollen max. \u00fcberpr\u00fcft werdne) \n ticks (schrittweite) \n n (n-wege-kreuzung) \n durchl\u00e4ufe (wieviele durchl\u00e4ufe pro suchdurchgang)");
            return;
        }
        inputosm = args[0];
        outputosm = args[1];
        maxchannelsearch = Integer.parseInt(args[2]);
        ticks = Integer.parseInt(args[3]);
        n = Integer.parseInt(args[4]);
        runs = Integer.parseInt(args[5]);
        File file = new File(inputosm);
        OSMXMLReader xmlreader = new OSMXMLReader(file);
        xmlreader.parseXML();
        XMLFilterReader reader = new XMLFilterReader("/resources/xml/waysfilter.xml");
        reader.parseXML();
        ExecuteFilter ef = new ExecuteFilter(reader.getFilters(), xmlreader.getOSMGraph());
        ef.filter();
        ChannelDigraphBuilder cdgb = new ChannelDigraphBuilder(ef.getOutgoinggraph());
        cdgb.buildChannelDigraph();
        StrongConnectednessCalculator scc = new StrongConnectednessCalculator(cdgb.getDigraph());
        scc.calculateSCC();
        if (maxchannelsearch == 0) {
            OSMXMLWriter oxw = new OSMXMLWriter(outputosm, cdgb.getDigraph());
            try {
                oxw.writeXML();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            System.out.println("OSMXML erzeugt, breche an dieser Stelle ab");
            return;
        }
        JunctionChecker jc = new JunctionChecker(cdgb.getDigraph(), n);
        ArrayList<Channel> subset = new ArrayList<Channel>();
        Channel seed = new Channel();
        boolean isIn = false;
        long measuredIterateThroughTime = 0L;
        long measuredGenerateSubColumnTime = 0L;
        long measuredTime = 0L;
        for (int i = 5; i < maxchannelsearch; i += ticks) {
            measuredIterateThroughTime = 0L;
            measuredGenerateSubColumnTime = 0L;
            measuredTime = 0L;
            int jcf = 0;
            for (int j = 0; j < runs; ++j) {
                subset.clear();
                while (!(seed = cdgb.getDigraph().getChannelAtPosition((int)((double)cdgb.getDigraph().getChannels().size() * Math.random()))).isStrongConnected()) {
                }
                subset.add(seed);
                Channel vorChannel = seed;
                for (int k = 0; k < i - 1; ++k) {
                    isIn = false;
                    do {
                        Channel tempChannel;
                        if (!subset.contains(tempChannel = CLI.getNeighbourChannel(vorChannel))) {
                            subset.add(tempChannel);
                            seed = tempChannel;
                            isIn = true;
                            continue;
                        }
                        vorChannel = tempChannel;
                        isIn = false;
                    } while (!isIn);
                }
                long start = System.currentTimeMillis();
                jc.junctionSearch(subset);
                measuredTime += System.currentTimeMillis() - start;
                measuredIterateThroughTime += jc.getMeasuredIterateTime();
                measuredGenerateSubColumnTime += jc.getMeasuredGenerateTime();
                jcf += jc.getJunctions().size();
            }
            System.out.println("Channels: " + i + " Time(Iterate): " + measuredIterateThroughTime / (long)runs + " Time(Generate): " + measuredGenerateSubColumnTime / (long)runs + " Time(overall): " + measuredTime / (long)runs + " junctionsfound: " + jcf);
        }
    }

    private static Channel getNeighbourChannel(Channel seedChannel) {
        if (Math.random() < 0.5) {
            if (seedChannel.getPredChannels().size() >= 1) {
                return seedChannel.getPredChannels().get((int)((double)seedChannel.getPredChannels().size() * Math.random()));
            }
            return seedChannel;
        }
        if (seedChannel.getLeadsTo().size() >= 1) {
            return seedChannel.getLeadsTo().get((int)((double)seedChannel.getLeadsTo().size() * Math.random())).getToChannel();
        }
        return seedChannel;
    }
}

