/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.oauth;

import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.exif.ExifRewriter;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.GpsTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImportedImage;
import org.openstreetmap.josm.plugins.mapillary.MapillarySequence;
import org.openstreetmap.josm.plugins.mapillary.history.MapillaryRecord;
import org.openstreetmap.josm.plugins.mapillary.history.commands.CommandDelete;
import org.openstreetmap.josm.plugins.mapillary.oauth.MapillaryUser;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryUtils;
import org.openstreetmap.josm.plugins.mapillary.utils.PluginState;

public class UploadUtils {
    private static final String[] keys = new String[]{"key", "AWSAccessKeyId", "acl", "policy", "signature", "Content-Type"};
    private static final String UPLOAD_URL = "https://s3-eu-west-1.amazonaws.com/mapillary.uploads.manual.images";
    private static int c;

    public static File updateFile(MapillaryImportedImage image) throws ImageReadException, IOException, ImageWriteException {
        TiffImageMetadata exif;
        TiffOutputSet outputSet = null;
        TiffOutputDirectory exifDirectory = null;
        TiffOutputDirectory gpsDirectory = null;
        TiffOutputDirectory rootDirectory = null;
        JpegImageMetadata jpegMetadata = null;
        try {
            ImageMetadata metadata = Imaging.getMetadata((File)image.getFile());
            jpegMetadata = (JpegImageMetadata)metadata;
        }
        catch (Exception metadata) {
            // empty catch block
        }
        if (null != jpegMetadata && null != (exif = jpegMetadata.getExif())) {
            outputSet = exif.getOutputSet();
        }
        if (null == outputSet) {
            outputSet = new TiffOutputSet();
        }
        gpsDirectory = outputSet.getOrCreateGPSDirectory();
        exifDirectory = outputSet.getOrCreateExifDirectory();
        rootDirectory = outputSet.getOrCreateRootDirectory();
        gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION_REF);
        gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION_REF, new String[]{"T"});
        gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION);
        gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION, new RationalNumber[]{RationalNumber.valueOf((double)image.getCa())});
        exifDirectory.removeField((TagInfo)ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL);
        exifDirectory.add(ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL, new String[]{image.getDate("yyyy/MM/dd HH:mm:ss")});
        rootDirectory.removeField((TagInfo)TiffTagConstants.TIFF_TAG_IMAGE_DESCRIPTION);
        outputSet.setGPSInDegrees(image.getLatLon().lon(), image.getLatLon().lat());
        File tempFile = File.createTempFile("imagetoupload_" + c, ".tmp");
        ++c;
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tempFile));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image.getImage(), "jpg", outputStream);
        byte[] imageBytes = outputStream.toByteArray();
        new ExifRewriter().updateExifMetadataLossless(imageBytes, (OutputStream)os, outputSet);
        return tempFile;
    }

    public static void upload(MapillaryImportedImage image) {
        UploadUtils.upload(image, UUID.randomUUID());
    }

    public static void upload(MapillaryImportedImage image, UUID uuid) {
        String key = MapillaryUser.getUsername() + "/" + uuid.toString() + "/" + image.getLatLon().lat() + "_" + image.getLatLon().lon() + "_" + image.getCa() + "_" + image.getCapturedAt() + ".jpg";
        String policy = null;
        String signature = null;
        policy = MapillaryUser.getSecrets().get("images_policy");
        signature = MapillaryUser.getSecrets().get("images_hash");
        HashMap<String, String> hash = new HashMap<String, String>();
        hash.put("key", key);
        hash.put("AWSAccessKeyId", "AKIAI2X3BJAT2W75HILA");
        hash.put("acl", "private");
        hash.put("policy", policy);
        hash.put("signature", signature);
        hash.put("Content-Type", "image/jpeg");
        try {
            UploadUtils.uploadFile(UploadUtils.updateFile(image), hash);
        }
        catch (IOException | ImageReadException | ImageWriteException e) {
            Main.error((Throwable)e);
        }
    }

    public static void uploadFile(File file, HashMap<String, String> hash) throws IOException {
        HttpClientBuilder builder = HttpClientBuilder.create();
        CloseableHttpClient httpClient = builder.build();
        HttpPost httpPost = new HttpPost(UPLOAD_URL);
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        for (String key : keys) {
            if (hash.get(key) == null) {
                throw new IllegalArgumentException();
            }
            entityBuilder.addPart(key, (ContentBody)new StringBody(hash.get(key), ContentType.TEXT_PLAIN));
        }
        entityBuilder.addPart("file", (ContentBody)new FileBody(file));
        HttpEntity entity = entityBuilder.build();
        httpPost.setEntity(entity);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        if (response.getStatusLine().toString().contains("204")) {
            PluginState.imageUploaded();
            Main.info((String)(PluginState.getUploadString() + " (Mapillary)"));
        } else {
            Main.info((String)"Upload error");
        }
        file.delete();
        MapillaryUtils.updateHelpText();
    }

    public static void uploadSequence(MapillarySequence sequence, boolean delete) {
        Main.worker.submit(new SequenceUploadThread(new ConcurrentSkipListSet<MapillaryAbstractImage>(sequence.getImages()), delete));
    }

    private static class SingleUploadThread
    extends Thread {
        private final MapillaryImportedImage image;
        private final UUID uuid;

        private SingleUploadThread(MapillaryImportedImage image, UUID uuid) {
            this.image = image;
            this.uuid = uuid;
        }

        @Override
        public void run() {
            UploadUtils.upload(this.image, this.uuid);
        }
    }

    private static class SequenceUploadThread
    extends Thread {
        private final Set<MapillaryAbstractImage> images;
        private final UUID uuid;
        private final boolean delete;
        private final ThreadPoolExecutor ex;

        private SequenceUploadThread(Set<MapillaryAbstractImage> images, boolean delete) {
            this.images = images;
            this.uuid = UUID.randomUUID();
            this.ex = new ThreadPoolExecutor(8, 8, 25L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(15));
            this.delete = delete;
        }

        @Override
        public void run() {
            PluginState.imagesToUpload(this.images.size());
            MapillaryUtils.updateHelpText();
            for (MapillaryAbstractImage img : this.images) {
                if (!(img instanceof MapillaryImportedImage)) {
                    throw new IllegalArgumentException("The sequence contains downloaded images.");
                }
                this.ex.execute(new SingleUploadThread((MapillaryImportedImage)img, this.uuid));
                while (this.ex.getQueue().remainingCapacity() == 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Main.error((Throwable)e);
                    }
                }
            }
            this.ex.shutdown();
            try {
                this.ex.awaitTermination(15L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Main.error((Throwable)e);
            }
            if (this.delete) {
                MapillaryRecord.getInstance().addCommand(new CommandDelete(this.images));
            }
        }
    }
}

