/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.oauth;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Scanner;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapillary.oauth.MapillaryLoginListener;
import org.openstreetmap.josm.plugins.mapillary.oauth.MapillaryUser;
import org.openstreetmap.josm.tools.I18n;

public class OAuthPortListener
extends Thread {
    public static final int PORT = 8763;
    protected static final String RESPONSE = String.format("<!DOCTYPE html><html><head><meta charset=\"utf8\"><title>%s</title></head><body>%s</body></html>", I18n.tr((String)"Mapillary login", (Object[])new Object[0]), I18n.tr((String)"Login successful, return to JOSM.", (Object[])new Object[0]));
    private final MapillaryLoginListener callback;

    public OAuthPortListener(MapillaryLoginListener loginCallback) {
        this.callback = loginCallback;
    }

    @Override
    public void run() {
        try (ServerSocket serverSocket = new ServerSocket(8763);
             Socket clientSocket = serverSocket.accept();
             PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter(clientSocket.getOutputStream(), "UTF-8"), true);
             Scanner in = new Scanner(new InputStreamReader(clientSocket.getInputStream(), "UTF-8"));){
            String accessToken = null;
            while (in.hasNextLine() && accessToken == null) {
                String s = in.nextLine();
                if (s.contains("access_token=")) {
                    String[] ss = s.split("&");
                    for (int i = 0; i < ss.length && accessToken == null; ++i) {
                        if (!ss[i].startsWith("access_token=")) continue;
                        accessToken = ss[i].substring(ss[i].indexOf("access_token=") + 13, ss[i].length());
                    }
                    break;
                }
                if (!s.contains("keep-alive")) continue;
            }
            OAuthPortListener.writeContent(out);
            out.close();
            in.close();
            serverSocket.close();
            MapillaryUser.reset();
            Main.info((String)("Successful login with Mapillary, the access token is: " + accessToken));
            MapillaryUser.setTokenValid(true);
            if (Main.main != null) {
                Main.pref.put("mapillary.access-token", accessToken);
                String username = MapillaryUser.getUsername();
                Main.info((String)("The username is: " + username));
                if (this.callback != null) {
                    this.callback.onLogin(username);
                }
            }
        }
        catch (BindException e) {
            Main.warn((Throwable)e);
            return;
        }
        catch (IOException e) {
            Main.error((Throwable)e);
        }
    }

    private static void writeContent(PrintWriter out) {
        out.println("HTTP/1.1 200 OK");
        out.println("Content-Length: " + RESPONSE.length());
        out.println("Content-Type: text/html\r\n\r\n");
        out.println(RESPONSE);
    }
}

