/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.gui;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Calendar;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryDataListener;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImportedImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryFilterChooseSigns;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MapillaryFilterDialog
extends ToggleDialog
implements MapillaryDataListener {
    private static final long serialVersionUID = -4192029663670922103L;
    private static MapillaryFilterDialog instance;
    private static final String[] TIME_LIST;
    private final SpinnerNumberModel spinner;
    private final JCheckBox imported = new JCheckBox(I18n.tr((String)"Imported images", (Object[])new Object[0]));
    private final JCheckBox downloaded = new JCheckBox(new DownloadCheckBoxAction());
    private final JCheckBox onlySigns = new JCheckBox(new OnlySignsAction());
    private final JComboBox<String> time;
    private final JTextField user;
    private final SideButton updateButton = new SideButton((Action)new UpdateAction());
    private final SideButton resetButton = new SideButton((Action)new ResetAction());
    private final JButton signChooser = new JButton(new SignChooserAction());
    private final MapillaryFilterChooseSigns signFilter = MapillaryFilterChooseSigns.getInstance();
    private static final String[] SIGN_TAGS;
    private final JCheckBox[] SIGN_CHECKBOXES;

    private MapillaryFilterDialog() {
        super(I18n.tr((String)"Mapillary filter", (Object[])new Object[0]), "mapillaryfilter.png", I18n.tr((String)"Open Mapillary filter dialog", (Object[])new Object[0]), Shortcut.registerShortcut((String)I18n.tr((String)"Mapillary filter", (Object[])new Object[0]), (String)I18n.tr((String)"Open Mapillary filter dialog", (Object[])new Object[0]), (int)77, (int)5000), 200);
        this.SIGN_CHECKBOXES = new JCheckBox[]{this.signFilter.maxSpeed, this.signFilter.stop, this.signFilter.giveWay, this.signFilter.roundabout, this.signFilter.access, this.signFilter.access, this.signFilter.intersection, this.signFilter.direction, this.signFilter.direction, this.signFilter.intersection, this.signFilter.uneven, this.signFilter.noParking, this.signFilter.noOvertaking, this.signFilter.crossing, this.signFilter.noTurn, this.signFilter.noTurn};
        this.signChooser.setEnabled(false);
        JPanel signChooserPanel = new JPanel();
        signChooserPanel.setLayout(new FlowLayout(0));
        signChooserPanel.add(this.signChooser);
        JPanel fromPanel = new JPanel();
        fromPanel.setLayout(new FlowLayout(0));
        fromPanel.add(new JLabel(I18n.tr((String)"Not older than: ", (Object[])new Object[0])));
        this.spinner = new SpinnerNumberModel(1, 0, 10000, 1);
        fromPanel.add(new JSpinner(this.spinner));
        this.time = new JComboBox<String>(TIME_LIST);
        fromPanel.add(this.time);
        JPanel userSearchPanel = new JPanel();
        userSearchPanel.setLayout(new FlowLayout(0));
        this.user = new JTextField(10);
        this.user.addActionListener(new UpdateAction());
        userSearchPanel.add(new JLabel(I18n.tr((String)"User", (Object[])new Object[0])));
        userSearchPanel.add(this.user);
        this.imported.setSelected(true);
        this.downloaded.setSelected(true);
        JPanel panel = new JPanel();
        JPanel col1 = new JPanel(new GridLayout(2, 1));
        col1.add(this.downloaded);
        col1.add(fromPanel);
        panel.add(col1);
        JPanel col2 = new JPanel(new GridLayout(2, 1));
        col2.add(this.imported);
        col2.add(userSearchPanel);
        panel.add(col2);
        JPanel col3 = new JPanel(new GridLayout(2, 1));
        col3.add(this.onlySigns);
        col3.add(signChooserPanel);
        panel.add(col3);
        this.createLayout(panel, true, Arrays.asList(this.updateButton, this.resetButton));
    }

    public static synchronized MapillaryFilterDialog getInstance() {
        if (instance == null) {
            instance = new MapillaryFilterDialog();
        }
        return instance;
    }

    @Override
    public void imagesAdded() {
        this.refresh();
    }

    @Override
    public void selectedImageChanged(MapillaryAbstractImage oldImage, MapillaryAbstractImage newImage) {
    }

    public void reset() {
        this.imported.setSelected(true);
        this.downloaded.setSelected(true);
        this.onlySigns.setEnabled(true);
        this.onlySigns.setSelected(false);
        this.user.setText("");
        this.time.setSelectedItem(TIME_LIST[0]);
        this.spinner.setValue(1);
        this.refresh();
    }

    public synchronized void refresh() {
        boolean imported = this.imported.isSelected();
        boolean downloaded = this.downloaded.isSelected();
        boolean onlySigns = this.onlySigns.isSelected();
        for (MapillaryAbstractImage img : MapillaryLayer.getInstance().getData().getImages()) {
            img.setVisible(true);
            if (img instanceof MapillaryImportedImage) {
                if (imported) continue;
                img.setVisible(false);
                continue;
            }
            if (img instanceof MapillaryImage) {
                if (!downloaded) {
                    img.setVisible(false);
                    continue;
                }
                if (onlySigns) {
                    if (((MapillaryImage)img).getSigns().isEmpty()) {
                        img.setVisible(false);
                        continue;
                    }
                    if (!this.checkSigns((MapillaryImage)img)) {
                        img.setVisible(false);
                        continue;
                    }
                }
                if (!"".equals(this.user.getText()) && !this.user.getText().equals(((MapillaryImage)img).getUser())) {
                    img.setVisible(false);
                    continue;
                }
            }
            Long currentTime = MapillaryFilterDialog.currentTime();
            long[] timeFactor = new long[]{31536000000L, 2592000000L, 86400000L};
            for (int i = 1; i <= 3; ++i) {
                if (!TIME_LIST[i].equals(this.time.getSelectedItem()) || img.getCapturedAt() >= currentTime - ((Integer)this.spinner.getValue()).longValue() * timeFactor[i - 1]) continue;
                img.setVisible(false);
            }
        }
        Main.map.repaint();
    }

    private boolean checkSigns(MapillaryImage img) {
        for (int i = 0; i < SIGN_TAGS.length; ++i) {
            if (!MapillaryFilterDialog.checkSign(img, this.SIGN_CHECKBOXES[i], SIGN_TAGS[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean checkSign(MapillaryImage img, JCheckBox signCheckBox, String singString) {
        boolean contains = false;
        for (String sign : img.getSigns()) {
            if (!sign.contains(singString)) continue;
            contains = true;
        }
        return contains == signCheckBox.isSelected() && contains;
    }

    private static long currentTime() {
        Calendar cal = Calendar.getInstance();
        return cal.getTimeInMillis();
    }

    public static synchronized void destroyInstance() {
        instance = null;
    }

    static {
        TIME_LIST = new String[]{I18n.tr((String)"All", (Object[])new Object[0]), I18n.tr((String)"Years", (Object[])new Object[0]), I18n.tr((String)"Months", (Object[])new Object[0]), I18n.tr((String)"Days", (Object[])new Object[0])};
        SIGN_TAGS = new String[]{"prohibitory_speed_limit", "priority_stop", "other_give_way", "mandatory_roundabout", "other_no_entry", "prohibitory_no_traffic_both_ways", "danger_intersection", "mandatory_go", "mandatory_keep", "danger_priority_next_intersection", "danger_uneven_road", "prohibitory_no_parking", "prohibitory_on_overtaking", "danger_pedestrian_crossing", "prohibitory_no_u_turn", "prohibitory_noturn"};
    }

    private class SignChooserAction
    extends AbstractAction {
        private static final long serialVersionUID = 8706299665735930148L;

        public SignChooserAction() {
            this.putValue("Name", I18n.tr((String)"Choose signs", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MapillaryFilterChooseSigns dialog = MapillaryFilterChooseSigns.getInstance();
            JOptionPane pane = new JOptionPane(dialog, -1, 2);
            JDialog dlg = pane.createDialog(Main.parent, I18n.tr((String)"Choose signs", (Object[])new Object[0]));
            dlg.setVisible(true);
            if ((Integer)pane.getValue() == 0) {
                MapillaryFilterDialog.getInstance().refresh();
            }
            dlg.dispose();
        }
    }

    private class OnlySignsAction
    extends AbstractAction {
        private static final long serialVersionUID = -2937440338019185723L;

        public OnlySignsAction() {
            this.putValue("Name", I18n.tr((String)"Only images with signs", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MapillaryFilterDialog.this.signChooser.setEnabled(MapillaryFilterDialog.this.onlySigns.isSelected());
        }
    }

    private class ResetAction
    extends AbstractAction {
        private static final long serialVersionUID = 1178261778165525040L;

        public ResetAction() {
            this.putValue("Name", I18n.tr((String)"Reset", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MapillaryFilterDialog.getInstance().reset();
        }
    }

    private class UpdateAction
    extends AbstractAction {
        private static final long serialVersionUID = -7417238601979689863L;

        public UpdateAction() {
            this.putValue("Name", I18n.tr((String)"Update", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MapillaryFilterDialog.getInstance().refresh();
        }
    }

    private class DownloadCheckBoxAction
    extends AbstractAction {
        private static final long serialVersionUID = 4672634002899519496L;

        public DownloadCheckBoxAction() {
            this.putValue("Name", I18n.tr((String)"Downloaded images", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MapillaryFilterDialog.this.onlySigns.setEnabled(MapillaryFilterDialog.this.downloaded.isSelected());
        }
    }
}

