/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImportedImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.tools.I18n;

public class MapillaryExportDialog
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 8675637080225099248L;
    protected JOptionPane optionPane;
    public final JRadioButton all;
    public final JRadioButton sequence;
    public final JRadioButton selected;
    public final JRadioButton rewrite;
    public final ButtonGroup group;
    private final JButton choose;
    private final JLabel path;
    public JFileChooser chooser;
    protected String exportDirectory;
    private final JButton ok;

    public MapillaryExportDialog(JButton ok) {
        this.ok = ok;
        ok.setEnabled(false);
        this.setLayout(new BoxLayout(this, 3));
        RewriteButtonAction action = new RewriteButtonAction(this);
        this.group = new ButtonGroup();
        this.all = new JRadioButton(action);
        this.all.setText(I18n.tr((String)"Export all images", (Object[])new Object[0]));
        this.sequence = new JRadioButton(action);
        this.sequence.setText(I18n.tr((String)"Export selected sequence", (Object[])new Object[0]));
        this.selected = new JRadioButton(action);
        this.selected.setText(I18n.tr((String)"Export selected images", (Object[])new Object[0]));
        this.rewrite = new JRadioButton(action);
        this.rewrite.setText(I18n.tr((String)"Rewrite imported images", (Object[])new Object[0]));
        this.group.add(this.all);
        this.group.add(this.sequence);
        this.group.add(this.selected);
        this.group.add(this.rewrite);
        if (MapillaryLayer.getInstance().getData().getSelectedImage() == null || !(MapillaryLayer.getInstance().getData().getSelectedImage() instanceof MapillaryImage) || ((MapillaryImage)MapillaryLayer.getInstance().getData().getSelectedImage()).getSequence() == null) {
            this.sequence.setEnabled(false);
        }
        if (MapillaryLayer.getInstance().getData().getMultiSelectedImages().isEmpty()) {
            this.selected.setEnabled(false);
        }
        this.rewrite.setEnabled(false);
        for (MapillaryAbstractImage img : MapillaryLayer.getInstance().getData().getImages()) {
            if (!(img instanceof MapillaryImportedImage)) continue;
            this.rewrite.setEnabled(true);
        }
        this.path = new JLabel(I18n.tr((String)"Select a folder", (Object[])new Object[0]));
        this.choose = new JButton(I18n.tr((String)"Explore", (Object[])new Object[0]));
        this.choose.addActionListener(this);
        JPanel jpanel = new JPanel();
        jpanel.setLayout(new BoxLayout(jpanel, 3));
        jpanel.add(this.all);
        jpanel.add(this.sequence);
        jpanel.add(this.selected);
        jpanel.add(this.rewrite);
        jpanel.setAlignmentX(0.5f);
        this.path.setAlignmentX(0.5f);
        this.choose.setAlignmentX(0.5f);
        this.add(jpanel);
        this.add(this.path);
        this.add(this.choose);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.chooser = new JFileChooser();
        this.chooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        this.chooser.setDialogTitle(I18n.tr((String)"Select a directory", (Object[])new Object[0]));
        this.chooser.setFileSelectionMode(1);
        this.chooser.setAcceptAllFileFilterUsed(false);
        if (this.chooser.showOpenDialog(this) == 0) {
            this.path.setText(this.chooser.getSelectedFile().toString());
            this.updateUI();
            this.ok.setEnabled(true);
        }
    }

    public class RewriteButtonAction
    extends AbstractAction {
        private static final long serialVersionUID = -9103251296651015563L;
        private String lastPath;
        private final MapillaryExportDialog dlg;

        public RewriteButtonAction(MapillaryExportDialog dlg) {
            this.dlg = dlg;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MapillaryExportDialog.this.choose.setEnabled(!MapillaryExportDialog.this.rewrite.isSelected());
            if (MapillaryExportDialog.this.rewrite.isSelected()) {
                this.lastPath = this.dlg.path.getText();
                this.dlg.path.setText(" ");
            } else if (this.lastPath != null) {
                this.dlg.path.setText(this.lastPath);
            }
        }
    }
}

