/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.actions;

import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryDataListener;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.cache.CacheUtils;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryMainDialog;

public class WalkThread
extends Thread
implements MapillaryDataListener {
    private final int interval;
    private final MapillaryData data;
    private boolean end;
    private final boolean waitForFullQuality;
    private final boolean followSelected;
    private final boolean goForward;
    private BufferedImage lastImage;
    private volatile boolean paused;

    public WalkThread(int interval, boolean waitForPicture, boolean followSelected, boolean goForward) {
        this.interval = interval;
        this.waitForFullQuality = waitForPicture;
        this.followSelected = followSelected;
        this.goForward = goForward;
        this.data = MapillaryLayer.getInstance().getData();
        this.data.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) lbl-1000:
            // 2 sources

            {
                if (this.end || this.data.getSelectedImage().next() == null) ** GOTO lbl-1000
                image = this.data.getSelectedImage();
                if (!(image instanceof MapillaryImage)) ** GOTO lbl16
                ** GOTO lbl9
lbl-1000:
                // 1 sources

                {
                    this.end();
                    return;
lbl9:
                    // 2 sources

                    for (i = 0; i < 10 && image.next() != null; image = image.next(), ++i) {
                        CacheUtils.downloadPicture((MapillaryImage)image, CacheUtils.PICTURE.THUMBNAIL);
                    }
                    if (this.waitForFullQuality) {
                        for (i = 0; i < 3 && image.next() != null; image = image.next(), ++i) {
                            CacheUtils.downloadPicture((MapillaryImage)image, CacheUtils.PICTURE.FULL_IMAGE);
                        }
                    }
lbl16:
                    // 4 sources

                    try {
                        i = this;
                        synchronized (i) {
                            displayImage = MapillaryMainDialog.getInstance().mapillaryImageDisplay.getImage();
                            if (this.waitForFullQuality && image instanceof MapillaryImage) {
                                while (displayImage == this.lastImage || displayImage == null || displayImage.getWidth() < 2048) {
                                    this.wait(100L);
                                }
                            } else {
                                while (displayImage == this.lastImage || displayImage == null || displayImage.getWidth() < 320) {
                                    this.wait(100L);
                                }
                            }
                            while (this.paused) {
                                this.wait(100L);
                            }
                            this.wait(this.interval);
                            while (this.paused) {
                                this.wait(100L);
                            }
                        }
                        this.lastImage = MapillaryMainDialog.getInstance().mapillaryImageDisplay.getImage();
                        i = this;
                        synchronized (i) {
                            if (this.goForward) {
                                this.data.selectNext(this.followSelected);
                            } else {
                                this.data.selectPrevious(this.followSelected);
                            }
                            continue;
                        }
                    }
                    catch (InterruptedException e) {}
                    return;
                }
                break;
            }
        }
        catch (NullPointerException e) {
            return;
        }
        {
            ** while (true)
        }
    }

    @Override
    public void imagesAdded() {
    }

    @Override
    public void selectedImageChanged(MapillaryAbstractImage oldImage, MapillaryAbstractImage newImage) {
        if (newImage != oldImage.next()) {
            this.end();
            this.interrupt();
        }
    }

    public void play() {
        this.paused = false;
    }

    public void pause() {
        this.paused = true;
    }

    public void stopWalk() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.end();
            this.interrupt();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WalkThread.this.stopWalk();
                }
            });
        }
    }

    public void end() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.end = true;
            this.data.removeListener(this);
            MapillaryMainDialog.getInstance().setMode(MapillaryMainDialog.MODE.NORMAL);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WalkThread.this.end();
                }
            });
        }
    }
}

