/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryUtils;

public class MapillaryImportedImage
extends MapillaryAbstractImage {
    protected File file;

    public MapillaryImportedImage(double lat, double lon, double ca, File file) {
        this(lat, lon, ca, file, MapillaryUtils.currentDate());
    }

    public MapillaryImportedImage(double lat, double lon, double ca, File file, String datetimeOriginal) {
        super(lat, lon, ca);
        this.file = file;
        try {
            this.capturedAt = MapillaryUtils.getEpoch(datetimeOriginal, "yyyy:MM:dd HH:mm:ss");
        }
        catch (ParseException e) {
            try {
                this.capturedAt = MapillaryUtils.getEpoch(datetimeOriginal, "yyyy/MM/dd HH:mm:ss");
            }
            catch (ParseException e1) {
                this.capturedAt = MapillaryUtils.currentTime();
            }
        }
    }

    public BufferedImage getImage() throws IOException {
        if (this.file != null) {
            return ImageIO.read(this.file);
        }
        return null;
    }

    public File getFile() {
        return this.file;
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass() == this.getClass()) {
            return this.file.equals(((MapillaryImportedImage)other).file);
        }
        return false;
    }

    @Override
    public int compareTo(MapillaryAbstractImage image) {
        if (image instanceof MapillaryImage) {
            return this.file.compareTo(((MapillaryImportedImage)image).getFile());
        }
        return super.compareTo(image);
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

