/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class WikipediaApp {
    public static Pattern WIKIDATA_PATTERN = Pattern.compile("Q\\d+");

    private WikipediaApp() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<WikipediaEntry> getEntriesFromCoordinates(String wikipediaLang, LatLon min, LatLon max) {
        try {
            String bbox = min.lon() + "," + min.lat() + "," + max.lon() + "," + max.lat();
            String url = "https://tools.wmflabs.org/wp-world/marks.php?bbox=" + bbox + "&LANG=" + wikipediaLang;
            Main.info((String)("Wikipedia: GET " + url));
            XPathExpression xpathPlacemark = XPathFactory.newInstance().newXPath().compile("//Placemark");
            XPathExpression xpathName = XPathFactory.newInstance().newXPath().compile("name/text()");
            XPathExpression xpathCoord = XPathFactory.newInstance().newXPath().compile("Point/coordinates/text()");
            XPathExpression xpathDescr = XPathFactory.newInstance().newXPath().compile("description");
            try (InputStream in = Utils.openURL((URL)new URL(url));){
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
                NodeList nodes = (NodeList)xpathPlacemark.evaluate(doc, XPathConstants.NODESET);
                ArrayList<WikipediaEntry> entries = new ArrayList<WikipediaEntry>(nodes.getLength());
                for (int i = 0; i < nodes.getLength(); ++i) {
                    String[] coord = xpathCoord.evaluate(nodes.item(i)).split(",");
                    if (coord.length <= 2) continue;
                    String name = xpathName.evaluate(nodes.item(i));
                    String descr = xpathDescr.evaluate(nodes.item(i));
                    entries.add(new WikipediaEntry(name, descr, new LatLon(Double.parseDouble(coord[1]), Double.parseDouble(coord[0]))));
                }
                ArrayList<WikipediaEntry> arrayList = entries;
                return arrayList;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Exception decompiling
     */
    static List<WikipediaEntry> getEntriesFromCategory(String wikipediaLang, String category, int depth) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static List<WikipediaEntry> getEntriesFromClipboard(final String wikipediaLang) {
        List<String> clipboardLines = Arrays.asList(Utils.getClipboardContent().split("[\\n\\r]+"));
        return new ArrayList<WikipediaEntry>(Utils.transform(clipboardLines, (Utils.Function)new Utils.Function<String, WikipediaEntry>(){

            public WikipediaEntry apply(String x) {
                return new WikipediaEntry(x, wikipediaLang, x);
            }
        }));
    }

    static void updateWIWOSMStatus(String wikipediaLang, Collection<WikipediaEntry> entries) {
        ArrayList<String> articleNames = new ArrayList<String>();
        for (WikipediaEntry i : entries) {
            articleNames.add(i.wikipediaArticle);
        }
        HashMap<String, Boolean> status = new HashMap<String, Boolean>();
        if (!articleNames.isEmpty()) {
            String url = "https://tools.wmflabs.org/wiwosm/osmjson/getGeoJSON.php?action=check&lang=" + wikipediaLang;
            Main.info((String)("Wikipedia: POST " + url + " " + articleNames));
            try {
                HttpURLConnection connection = Utils.openHttpConnection((URL)new URL(url));
                connection.setDoOutput(true);
                try (OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");){
                    out.write("articles=" + Utils.encodeUrl((String)Utils.join((String)",", articleNames)));
                }
                var7_8 = null;
                try (Scanner scanner = new Scanner(connection.getInputStream(), "UTF-8").useDelimiter("\n");){
                    while (scanner.hasNext()) {
                        String line = scanner.next();
                        String[] x = line.split("\t");
                        if (x.length == 2) {
                            status.put(x[0], "1".equals(x[1]));
                            continue;
                        }
                        Main.error((String)("Unknown element " + line));
                    }
                }
                catch (Throwable throwable) {
                    var7_8 = throwable;
                    throw throwable;
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        for (WikipediaEntry i : entries) {
            i.setWiwosmStatus((Boolean)status.get(i.wikipediaArticle));
        }
    }

    static Collection<String> getWikipediaArticles(final String wikipediaLang, OsmPrimitive p) {
        Map tags = p.getKeys();
        return Utils.transform((Collection)Utils.filter(Arrays.asList(WikipediaLangArticle.parseTag("wikipedia", (String)tags.get("wikipedia")), WikipediaLangArticle.parseTag("wikipedia:" + wikipediaLang, (String)tags.get("wikipedia:" + wikipediaLang))), (Predicate)new Predicate<WikipediaLangArticle>(){

            public boolean evaluate(WikipediaLangArticle wp) {
                return wp != null && wikipediaLang.equals(wp.lang);
            }
        }), (Utils.Function)new Utils.Function<WikipediaLangArticle, String>(){

            public String apply(WikipediaLangArticle wp) {
                return wp.article;
            }
        });
    }

    static Map<String, String> getWikidataForArticles(String wikipediaLang, Collection<String> articles) {
        try {
            String url = "https://www.wikidata.org/w/api.php?action=wbgetentities&props=sitelinks&sites=" + wikipediaLang + "wiki" + "&sitefilter=" + wikipediaLang + "wiki" + "&format=xml" + "&titles=" + Utils.join((String)"|", (Collection)Utils.transform(articles, (Utils.Function)new Utils.Function<String, String>(){

                public String apply(String x) {
                    return Utils.encodeUrl((String)x);
                }
            }));
            Main.info((String)("Wikipedia: GET " + url));
            TreeMap<String, String> r = new TreeMap<String, String>();
            try (InputStream in = Utils.openURL((URL)new URL(url));){
                Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
                NodeList nodes = (NodeList)XPathFactory.newInstance().newXPath().compile("//entity").evaluate(xml, XPathConstants.NODESET);
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    String wikidata = (String)XPathFactory.newInstance().newXPath().compile("./@id").evaluate(node, XPathConstants.STRING);
                    String wikipedia = (String)XPathFactory.newInstance().newXPath().compile("./sitelinks/sitelink/@title").evaluate(node, XPathConstants.STRING);
                    r.put(wikipedia, wikidata);
                }
            }
            return r;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getLabelForWikidata(String wikidataId, String preferredLanguage) {
        try {
            CheckParameterUtil.ensureThat((boolean)WIKIDATA_PATTERN.matcher(wikidataId).matches(), (String)"Invalid Wikidata ID given");
            String url = "https://www.wikidata.org/w/api.php?action=wbgetentities&props=labels&ids=" + wikidataId + "&languages=" + preferredLanguage + "&languagefallback=en" + "&format=xml";
            Main.info((String)("Wikipedia: GET " + url));
            try (InputStream in = Utils.openURL((URL)new URL(url));){
                Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
                Node label = (Node)XPathFactory.newInstance().newXPath().compile("//label").evaluate(xml, XPathConstants.NODE);
                if (label == null) {
                    String string = null;
                    return string;
                }
                String string = (String)XPathFactory.newInstance().newXPath().compile("./@value").evaluate(label, XPathConstants.STRING);
                return string;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static Collection<WikipediaLangArticle> getInterwikiArticles(String wikipediaLang, String article) {
        try {
            ArrayList<WikipediaLangArticle> r = new ArrayList<WikipediaLangArticle>();
            String url = "https://" + wikipediaLang + ".wikipedia.org/w/api.php" + "?action=query" + "&prop=langlinks" + "&titles=" + Utils.encodeUrl((String)article) + "&lllimit=500" + "&format=xml";
            Main.info((String)("Wikipedia: GET " + url));
            try (InputStream in = Utils.openURL((URL)new URL(url));){
                Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
                NodeList nodes = (NodeList)XPathFactory.newInstance().newXPath().compile("//ll").evaluate(xml, XPathConstants.NODESET);
                for (int i = 0; i < nodes.getLength(); ++i) {
                    String lang = nodes.item(i).getAttributes().getNamedItem("lang").getTextContent();
                    String name = nodes.item(i).getTextContent();
                    r.add(new WikipediaLangArticle(lang, name));
                }
            }
            return r;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> List<List<T>> partitionList(final List<T> list, final int size) {
        return new AbstractList<List<T>>(){

            @Override
            public List<T> get(int index) {
                int fromIndex = index * size;
                int toIndex = Math.min(fromIndex + size, list.size());
                return list.subList(fromIndex, toIndex);
            }

            @Override
            public int size() {
                return (int)Math.ceil((float)list.size() / (float)size);
            }
        };
    }

    static class WikipediaEntry
    implements Comparable<WikipediaEntry> {
        final String name;
        final String wikipediaLang;
        final String wikipediaArticle;
        final LatLon coordinate;
        private Boolean wiwosmStatus;

        public WikipediaEntry(String name, String description, LatLon coordinate) {
            this.name = name;
            this.coordinate = coordinate;
            WikipediaLangArticle wp = WikipediaLangArticle.parseFromUrl(this.getHrefFromDescription(description));
            if (wp == null) {
                Main.warn((String)("Could not extract Wikipedia tag from: " + this.getHrefFromDescription(description)));
            }
            this.wikipediaLang = wp == null ? null : wp.lang;
            this.wikipediaArticle = wp == null ? null : wp.article;
        }

        public WikipediaEntry(String name, String wikipediaLang, String wikipediaArticle) {
            this.name = name;
            this.wikipediaLang = wikipediaLang;
            this.wikipediaArticle = wikipediaArticle;
            this.coordinate = null;
        }

        protected final String getHrefFromDescription(String description) {
            if (description == null) {
                return null;
            }
            Matcher m = Pattern.compile(".*href=\"(.+?)\".*").matcher(description);
            if (m.matches()) {
                return m.group(1);
            }
            Main.warn((String)("Could not parse URL from: " + description));
            return null;
        }

        protected final Tag createWikipediaTag() {
            return new Tag("wikipedia", this.wikipediaLang + ":" + this.wikipediaArticle);
        }

        private void updateWiwosmStatus() {
            try {
                String url = "https://tools.wmflabs.org/wiwosm/osmjson/getGeoJSON.php?action=check&lang=" + this.wikipediaLang + "&article=" + Utils.encodeUrl((String)this.wikipediaArticle);
                Main.info((String)("Wikipedia: GET " + url));
                try (InputStream in = Utils.openURL((URL)new URL(url));
                     Scanner scanner = new Scanner(in, "UTF-8");){
                    this.wiwosmStatus = scanner.hasNextInt() && scanner.nextInt() == 1;
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void setWiwosmStatus(Boolean wiwosmStatus) {
            this.wiwosmStatus = wiwosmStatus;
        }

        public Boolean getWiwosmStatus() {
            return this.wiwosmStatus;
        }

        public String getBrowserUrl() {
            return "https://" + this.wikipediaLang + ".wikipedia.org/wiki/" + Utils.encodeUrl((String)this.wikipediaArticle.replace(" ", "_"));
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(WikipediaEntry o) {
            return this.name.compareTo(o.name);
        }
    }

    static class WikipediaLangArticle {
        final String lang;
        final String article;

        public WikipediaLangArticle(String lang, String article) {
            this.lang = lang;
            this.article = article;
        }

        public static WikipediaLangArticle parseFromUrl(String url) {
            if (url == null) {
                return null;
            }
            url = Utils.decodeUrl((String)url);
            Matcher m = Pattern.compile("(https?:)?//(\\w*)\\.wikipedia\\.org/wiki/(.*)").matcher(url);
            if (!m.matches()) {
                return null;
            }
            return new WikipediaLangArticle(m.group(2), m.group(3));
        }

        public static WikipediaLangArticle parseTag(String key, String value) {
            if (value == null) {
                return null;
            }
            if (value.startsWith("http")) {
                return WikipediaLangArticle.parseFromUrl(value);
            }
            if (value.contains(":")) {
                String[] item = Utils.decodeUrl((String)value).split(":", 2);
                String article = item[1].replace("_", " ");
                return new WikipediaLangArticle(item[0], article);
            }
            if (key.startsWith("wikipedia:")) {
                String[] item;
                String lang = key.split(":", 2)[1];
                String article = item[(item = Utils.decodeUrl((String)value).split(":", 2)).length == 2 ? 1 : 0].replace("_", " ");
                return new WikipediaLangArticle(lang, article);
            }
            return null;
        }

        public String toString() {
            return this.lang + ":" + this.article;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WikipediaLangArticle that = (WikipediaLangArticle)o;
            return Objects.equals(this.lang, that.lang) && Objects.equals(this.article, that.article);
        }

        public int hashCode() {
            return Objects.hash(this.lang, this.article);
        }
    }
}

