/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.oauth;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapillary.oauth.OAuthUtils;

public class MapillaryUser {
    private static String username;
    private static String imagesPolicy;
    private static String imagesHash;
    public static boolean isTokenValid;

    public static String getUsername() {
        if (!isTokenValid) {
            return null;
        }
        if (username == null) {
            try {
                username = OAuthUtils.getWithHeader(new URL("https://a.mapillary.com/v2/me?client_id=T1Fzd20xZjdtR0s1VDk5OFNIOXpYdzoxNDYyOGRkYzUyYTFiMzgz")).getString("username");
            }
            catch (IOException e) {
                Main.info((String)"Invalid Mapillary token, reseting field");
                MapillaryUser.reset();
            }
        }
        return username;
    }

    public static Map<String, String> getSecrets() {
        if (!isTokenValid) {
            return null;
        }
        HashMap<String, String> hash = new HashMap<String, String>();
        try {
            if (imagesHash == null) {
                imagesHash = OAuthUtils.getWithHeader(new URL("https://a.mapillary.com/v2/me/uploads/secrets?client_id=T1Fzd20xZjdtR0s1VDk5OFNIOXpYdzoxNDYyOGRkYzUyYTFiMzgz")).getString("images_hash");
            }
            hash.put("images_hash", imagesHash);
            if (imagesPolicy == null) {
                imagesPolicy = OAuthUtils.getWithHeader(new URL("https://a.mapillary.com/v2/me/uploads/secrets?client_id=T1Fzd20xZjdtR0s1VDk5OFNIOXpYdzoxNDYyOGRkYzUyYTFiMzgz")).getString("images_policy");
            }
        }
        catch (IOException e) {
            Main.info((String)"Invalid Mapillary token, reseting field");
            MapillaryUser.reset();
        }
        hash.put("images_policy", imagesPolicy);
        return hash;
    }

    public static void reset() {
        username = null;
        imagesPolicy = null;
        imagesHash = null;
        isTokenValid = false;
        Main.pref.put("mapillary.access-token", null);
    }

    static {
        isTokenValid = true;
    }
}

