/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.gui;

import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryMainDialog;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryUtils;
import org.openstreetmap.josm.tools.I18n;

public class HyperlinkLabel
extends JLabel
implements ActionListener {
    private static final long serialVersionUID = -8965989079294159405L;
    private String text;
    private URL url;
    private String key;

    public HyperlinkLabel() {
        super(I18n.tr((String)"View in website", (Object[])new Object[0]), 4);
        this.addActionListener(this);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.enableEvents(16L);
    }

    @Override
    public void setText(String text) {
        super.setText("<html><font color=\"#0000CF\" size=\"2\">" + text + "</font></html>");
        this.text = text;
    }

    public void setURL(String key) {
        this.key = key;
        if (key == null) {
            this.url = null;
            return;
        }
        try {
            this.url = new URL("http://www.mapillary.com/map/im/" + key);
        }
        catch (MalformedURLException e) {
            Main.error((Throwable)e);
        }
    }

    public String getNormalText() {
        return this.text;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.getID() == 500) {
            if (e.getButton() == 1) {
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getNormalText()));
            }
            if (e.getButton() == 3) {
                LinkPopUp menu = new LinkPopUp();
                menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    protected void fireActionPerformed(ActionEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ActionListener.class) continue;
            ActionListener listener = (ActionListener)listeners[i + 1];
            listener.actionPerformed(evt);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.url == null) {
            return;
        }
        try {
            MapillaryUtils.browse(this.url);
        }
        catch (IOException e1) {
            Main.error((Throwable)e1);
        }
    }

    private class LinkPopUp
    extends JPopupMenu {
        private static final long serialVersionUID = 1384054752970921552L;
        private JMenuItem copy = new JMenuItem(I18n.tr((String)"Copy key", (Object[])new Object[0]));
        private JMenuItem copyTag;
        private JMenuItem edit;

        public LinkPopUp() {
            this.copy.addActionListener(new copyAction());
            this.add(this.copy);
            this.copyTag = new JMenuItem(I18n.tr((String)"Copy key tag", (Object[])new Object[0]));
            this.copyTag.addActionListener(new copyTagAction());
            this.add(this.copyTag);
            this.edit = new JMenuItem(I18n.tr((String)"Edit on website", (Object[])new Object[0]));
            this.edit.addActionListener(new editAction());
            this.add(this.edit);
        }

        private class editAction
        implements ActionListener {
            private editAction() {
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    MapillaryUtils.browse(new URL("http://www.mapillary.com/map/e/" + HyperlinkLabel.this.key));
                }
                catch (IOException e) {
                    Main.error((Throwable)e);
                }
            }
        }

        private class copyTagAction
        implements ActionListener {
            private copyTagAction() {
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                StringSelection stringSelection = new StringSelection("mapillary=" + ((MapillaryImage)MapillaryMainDialog.getInstance().getImage()).getKey());
                Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
                clpbrd.setContents(stringSelection, null);
            }
        }

        private class copyAction
        implements ActionListener {
            private copyAction() {
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                StringSelection stringSelection = new StringSelection(((MapillaryImage)MapillaryMainDialog.getInstance().getImage()).getKey());
                Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
                clpbrd.setContents(stringSelection, null);
            }
        }
    }
}

