/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.traffico.TrafficoSign;
import org.openstreetmap.josm.plugins.mapillary.traffico.TrafficoSignElement;
import org.openstreetmap.josm.tools.I18n;

public class MapillaryTrafficSignLayer
extends AbstractModifiableLayer {
    private static final String TRAFFICO_PATH = "data/fonts/traffico/traffico.ttf";
    private static MapillaryTrafficSignLayer instance;
    private final Font traffico;

    private MapillaryTrafficSignLayer() throws IOException {
        super("Mapillary traffic signs");
        try {
            this.traffico = Font.createFont(0, new File(TRAFFICO_PATH)).deriveFont(50.0f);
        }
        catch (FontFormatException e) {
            throw new IOException(I18n.tr((String)"Traffic sign font at ''{0}'' has wrong format.", (Object[])new Object[]{TRAFFICO_PATH}), e);
        }
        catch (IOException e) {
            throw new IOException(I18n.tr((String)"Could not read font-file from ''{{0}}''.", (Object[])new Object[]{TRAFFICO_PATH}), e);
        }
    }

    public static MapillaryTrafficSignLayer getInstance() throws IOException {
        if (instance == null) {
            instance = new MapillaryTrafficSignLayer();
        }
        return instance;
    }

    public boolean isModified() {
        return false;
    }

    public void paint(Graphics2D g, MapView mv, Bounds box) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(this.traffico);
        Point[] points = new Point[]{mv.getPoint(new LatLon(49.01058, 8.40743)), mv.getPoint(new LatLon(49.01116, 8.40679)), mv.getPoint(new LatLon(49.01038, 8.40636))};
        TrafficoSignElement[][] signs = new TrafficoSignElement[][]{TrafficoSign.getSign("europe", "mandatory_cycle_track"), TrafficoSign.getSign("de", "information_bus_stop"), TrafficoSign.getSign("europe", "information_pedestrian_crossing")};
        for (int i = 0; i < signs.length && i < points.length; ++i) {
            for (TrafficoSignElement layer : signs[i]) {
                g.setColor(layer.getColor());
                g.drawString("" + layer.getGlyph(), points[i].x - 25, points[i].y + 25);
            }
        }
        g.setColor(Color.MAGENTA);
        for (MapillaryAbstractImage img : MapillaryLayer.getInstance().getData().getImages()) {
            if (!(img instanceof MapillaryImage)) continue;
            g.fillOval(mv.getPoint((LatLon)img.getLatLon()).x - 3, mv.getPoint((LatLon)img.getLatLon()).y - 3, 6, 6);
            if (((MapillaryImage)img).getSigns().size() < 1) continue;
            Point imgLoc = mv.getPoint(img.getLatLon());
            for (TrafficoSignElement e : TrafficoSign.getSign("de", ((MapillaryImage)img).getSigns().get(0))) {
                g.setColor(e.getColor());
                g.drawString("" + e.getGlyph(), imgLoc.x, imgLoc.y);
            }
        }
    }

    public Icon getIcon() {
        return MapillaryPlugin.ICON16;
    }

    public String getToolTipText() {
        return null;
    }

    public void mergeFrom(Layer from) {
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public Component getInfoComponent() {
        return new JLabel("Mapillary traffic sign layer");
    }

    public Action[] getMenuEntries() {
        return new Action[0];
    }
}

