/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryDataListener;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.cache.CacheUtils;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryMainDialog;

public class MapillaryData {
    private List<MapillaryAbstractImage> images;
    private MapillaryAbstractImage selectedImage = null;
    private MapillaryAbstractImage highlightedImage;
    private final List<MapillaryAbstractImage> multiSelectedImages;
    private final CopyOnWriteArrayList<MapillaryDataListener> listeners = new CopyOnWriteArrayList();
    public CopyOnWriteArrayList<Bounds> bounds;

    protected MapillaryData() {
        this.images = new CopyOnWriteArrayList<MapillaryAbstractImage>();
        this.multiSelectedImages = new ArrayList<MapillaryAbstractImage>();
        this.addListener(MapillaryPlugin.getWalkAction());
        this.addListener(MapillaryPlugin.getZoomAction());
        this.addListener(MapillaryPlugin.getUploadAction());
        if (Main.main != null) {
            this.addListener(MapillaryMainDialog.getInstance());
        }
    }

    public synchronized void add(List<MapillaryAbstractImage> images) {
        this.add(images, true);
    }

    public synchronized void add(MapillaryAbstractImage image) {
        this.add(image, true);
    }

    public synchronized void remove(MapillaryAbstractImage image) {
        if (Main.main != null && MapillaryMainDialog.getInstance().getImage() != null) {
            MapillaryMainDialog.getInstance().setImage(null);
            MapillaryMainDialog.getInstance().updateImage();
        }
        this.setSelectedImage(null);
        this.images.remove(image);
        if (image.getSequence() != null) {
            image.getSequence().remove(image);
        }
        if (Main.main != null) {
            MapillaryData.dataUpdated();
        }
    }

    public synchronized void remove(List<MapillaryAbstractImage> images) {
        for (MapillaryAbstractImage img : images) {
            this.remove(img);
        }
    }

    public void addListener(MapillaryDataListener lis) {
        this.listeners.add(lis);
    }

    public void removeListener(MapillaryDataListener lis) {
        this.listeners.remove(lis);
    }

    public synchronized void add(List<MapillaryAbstractImage> images, boolean update) {
        for (MapillaryAbstractImage image : images) {
            this.add(image, update);
        }
    }

    public void setHighlightedImage(MapillaryAbstractImage image) {
        this.highlightedImage = image;
    }

    public MapillaryAbstractImage getHighlightedImage() {
        return this.highlightedImage;
    }

    public synchronized void add(MapillaryAbstractImage image, boolean update) {
        if (!this.images.contains(image)) {
            this.images.add(image);
        }
        if (update) {
            MapillaryData.dataUpdated();
        }
        this.fireImagesAdded();
    }

    public static synchronized void dataUpdated() {
        if (Main.main != null) {
            Main.map.mapView.repaint();
        }
    }

    public List<MapillaryAbstractImage> getImages() {
        return this.images;
    }

    public MapillaryAbstractImage getSelectedImage() {
        return this.selectedImage;
    }

    private void fireImagesAdded() {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (MapillaryDataListener lis : this.listeners) {
            if (lis == null) continue;
            lis.imagesAdded();
        }
    }

    public void selectNext() {
        this.selectNext(Main.pref.getBoolean("mapillary.move-to-picture", true));
    }

    public void selectNext(boolean moveToPicture) {
        if (this.getSelectedImage() == null) {
            throw new IllegalStateException();
        }
        if (this.getSelectedImage().getSequence() == null) {
            throw new IllegalStateException();
        }
        MapillaryAbstractImage tempImage = this.selectedImage;
        while (tempImage.next() != null) {
            if (!(tempImage = tempImage.next()).isVisible()) continue;
            this.setSelectedImage(tempImage, moveToPicture);
            break;
        }
    }

    public void selectPrevious() {
        this.selectPrevious(Main.pref.getBoolean("mapillary.move-to-picture", true));
    }

    public void selectPrevious(boolean moveToPicture) {
        if (this.getSelectedImage() == null) {
            throw new IllegalStateException();
        }
        if (this.getSelectedImage().getSequence() == null) {
            throw new IllegalStateException();
        }
        MapillaryAbstractImage tempImage = this.selectedImage;
        while (tempImage.previous() != null) {
            if (!(tempImage = tempImage.previous()).isVisible()) continue;
            this.setSelectedImage(tempImage, moveToPicture);
            break;
        }
    }

    public void setSelectedImage(MapillaryAbstractImage image) {
        this.setSelectedImage(image, false);
    }

    public void setSelectedImage(MapillaryAbstractImage image, boolean zoom) {
        MapillaryAbstractImage oldImage = this.selectedImage;
        this.selectedImage = image;
        this.multiSelectedImages.clear();
        this.multiSelectedImages.add(image);
        if (image != null && Main.main != null && image instanceof MapillaryImage) {
            MapillaryImage mapillaryImage = (MapillaryImage)image;
            if (mapillaryImage.next() != null) {
                CacheUtils.downloadPicture((MapillaryImage)mapillaryImage.next());
                if (mapillaryImage.next().next() != null) {
                    CacheUtils.downloadPicture((MapillaryImage)mapillaryImage.next().next());
                }
            }
            if (mapillaryImage.previous() != null) {
                CacheUtils.downloadPicture((MapillaryImage)mapillaryImage.previous());
                if (mapillaryImage.previous().previous() != null) {
                    CacheUtils.downloadPicture((MapillaryImage)mapillaryImage.previous().previous());
                }
            }
        }
        if (zoom && Main.main != null) {
            Main.map.mapView.zoomTo(this.getSelectedImage().getLatLon());
        }
        if (Main.main != null) {
            Main.map.mapView.repaint();
        }
        this.fireSelectedImageChanged(oldImage, this.selectedImage);
    }

    private void fireSelectedImageChanged(MapillaryAbstractImage oldImage, MapillaryAbstractImage newImage) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (MapillaryDataListener lis : this.listeners) {
            if (lis == null) continue;
            lis.selectedImageChanged(oldImage, newImage);
        }
    }

    public void addMultiSelectedImage(MapillaryAbstractImage image) {
        if (!this.multiSelectedImages.contains(image)) {
            if (this.getSelectedImage() != null) {
                this.multiSelectedImages.add(image);
            } else {
                this.setSelectedImage(image);
            }
        }
        if (Main.main != null) {
            Main.map.mapView.repaint();
        }
    }

    public void addMultiSelectedImage(List<MapillaryAbstractImage> images) {
        for (MapillaryAbstractImage image : images) {
            if (this.multiSelectedImages.contains(image)) continue;
            if (this.getSelectedImage() != null) {
                this.multiSelectedImages.add(image);
                continue;
            }
            this.setSelectedImage(image);
        }
        Main.map.mapView.repaint();
    }

    public List<MapillaryAbstractImage> getMultiSelectedImages() {
        return this.multiSelectedImages;
    }

    public synchronized void setImages(List<MapillaryAbstractImage> images) {
        this.images = new ArrayList<MapillaryAbstractImage>(images);
    }

    public int size() {
        return this.images.size();
    }
}

