/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;

public class MapillarySequence {
    private final List<MapillaryAbstractImage> images = new ArrayList<MapillaryAbstractImage>();
    private String key;
    private long created_at;

    public MapillarySequence() {
    }

    public MapillarySequence(String key, long created_at) {
        this.key = key;
        this.created_at = created_at;
    }

    public List<MapillaryAbstractImage> getImages() {
        return this.images;
    }

    public long getCreatedAt() {
        return this.created_at;
    }

    public synchronized void add(MapillaryAbstractImage image) {
        this.images.add(image);
    }

    public String getKey() {
        return this.key;
    }

    public synchronized void add(List<MapillaryAbstractImage> images) {
        for (MapillaryAbstractImage image : images) {
            this.add(image);
        }
    }

    public void remove(MapillaryAbstractImage image) {
        this.images.remove(image);
    }

    public MapillaryAbstractImage next(MapillaryAbstractImage image) {
        if (!this.images.contains(image)) {
            throw new IllegalArgumentException();
        }
        int i = this.images.indexOf(image);
        if (i == this.images.size() - 1) {
            return null;
        }
        return this.images.get(i + 1);
    }

    public MapillaryAbstractImage previous(MapillaryAbstractImage image) {
        if (!this.images.contains(image)) {
            throw new IllegalArgumentException();
        }
        int i = this.images.indexOf(image);
        if (i == 0) {
            return null;
        }
        return this.images.get(i - 1);
    }
}

